\name{action_predate}
\alias{g3a_predate_catchability_totalfleet}
\alias{g3a_predate_catchability_numberfleet}
\alias{g3a_predate_catchability_linearfleet}
\alias{g3a_predate_catchability_project}
\alias{g3a_predate_catchability_effortfleet}
\alias{g3a_predate_catchability_quotafleet}
\alias{g3a_predate_maxconsumption}
\alias{g3a_predate_catchability_predator}
\alias{g3a_predate}
\alias{g3a_predate_fleet}
\alias{g3a_predate_totalfleet}
\concept{G3 action}

\title{Gadget3 predation actions}
\description{
  Add predation to a g3 model
}

\usage{
g3a_predate_catchability_totalfleet(E)

g3a_predate_catchability_numberfleet(E)

g3a_predate_catchability_linearfleet(E)

g3a_predate_catchability_project(
    quota_f = NULL,
    landings_f = NULL,
    interim_f = g3_parameterized("quota.interim", value = 0,
        by_predator = TRUE, by_step = TRUE),
    quota_prop = g3_parameterized("quota.prop", by_predator = TRUE, value = 1),
    cons_step = g3_parameterized("cons.step", by_predator = TRUE, by_step = TRUE,
        value = quote( step_lengths / 12.0 )),
    interim_unit = unit,
    unit = c("biomass", "biomass-year", "harvest-rate", "harvest-rate-year",
             "individuals", "individuals-year") )

g3a_predate_catchability_effortfleet(catchability_fs, E)

g3a_predate_catchability_quotafleet(quota_table, E,
                                    sum_stocks = list(),
                                    recalc_f = NULL)

g3a_predate_maxconsumption(
        m0 = g3_parameterized('consumption.m0', value = 1,
            by_predator = TRUE, optimise = FALSE),
        m1 = g3_parameterized('consumption.m1', value = 0,
            by_predator = TRUE, optimise = FALSE),
        m2 = g3_parameterized('consumption.m2', value = 0,
            by_predator = TRUE, optimise = FALSE),
        m3 = g3_parameterized('consumption.m3', value = 0,
            by_predator = TRUE, optimise = FALSE),
        temperature = 0 )

g3a_predate_catchability_predator(
        prey_preferences = 1,
        energycontent = g3_parameterized('energycontent', value = 1,
            by_stock = by_stock, optimise = FALSE),
        half_feeding_f = g3_parameterized('halffeeding',
            by_predator = by_predator, optimise = FALSE),
        max_consumption = g3a_predate_maxconsumption(temperature = temperature),
        temperature = 0,
        by_predator = TRUE,
        by_stock = TRUE )

g3a_predate(
        predstock,
        prey_stocks,
        suitabilities,
        catchability_f,
        overconsumption_f = quote( dif_pmin(stock__consratio, 0.95, 1e3) ),
        run_f = ~TRUE,
        run_at = g3_action_order$predate )

# NB: Deprecated interface, use g3a_predate()
g3a_predate_fleet(fleet_stock, prey_stocks, suitabilities, catchability_f,
    overconsumption_f = quote( dif_pmin(stock__consratio, 0.95, 1e3) ),
    run_f = ~TRUE, run_at = g3_action_order$predate)

# NB: Deprecated interface, use g3a_predate() with g3a_predate_catchability_totalfleet
g3a_predate_totalfleet(fleet_stock, prey_stocks, suitabilities, amount_f,
    overconsumption_f = quote( dif_pmin(stock__consratio, 0.95, 1e3) ),
    run_f = ~TRUE, run_at = g3_action_order$predate)
}

\arguments{
  \item{predstock, fleet_stock}{
    \code{\link{g3_stock}} that describes the harvesting predators/fleet,
    or a list of \code{\link{g3_stock}} objects, in which case \code{\link{g3a_predate}} will be run for each in turn.
  }
  \item{prey_stocks}{
    List of \code{\link{g3_stock}}s that maturing \var{stock} should move into.
  }
  \item{suitabilities}{
    Either a list of stock names to \link{formula} objects, with an optional unnamed
    default option, or a \link{formula} object (which is always used).

    Each \link{formula} should define suitability of a stock, for example
    by using \code{\link{g3_suitability_exponentiall50}}.
  }
  \item{catchability_f}{
    A list of \link{formula}s generated by one of the \code{g3a_predate_catchability_*} functions,
    which define the total biomass a fleet is able to catch.
  }
  \item{E, landings_f}{
    A \link{formula} defining total catch a fleet can harvest at the current time/area (totalfleet/numberfleet),
    or a scaling factor used to define the stock caught (linearfleet/effortfleet/quotafleet).
  }
  \item{quota_f}{
    A per-year quota for use during projection time periods, or for the whole model if \var{landings_f} is \code{NULL}.
    Generally, this will be produced by \code{\link{g3_quota}}.
  }
  \item{interim_f}{
    A \link{formula} used to determine catch in the gap between landings data & a quota calculated from projections.
  }
  \item{quota_prop}{
    A quota can apply to multiple fleets, in which case use this parameter to assign the proportion of quota available to the current fleet.
    Note that ideally all \var{quota_prop} values sum to 1, but this doesn't have to be the case (e.g. over/under-utilisation of quotas).
  }
  \item{cons_step}{
    The proportion of the per-year quota that is used in each step.
    As with \var{quota_prop} ideally all values sum to 1.
  }
  \item{unit, interim_unit}{
    The unit that \var{landings_f} / \var{interim_f} is provided in.
    "biomass", "effort", "individuals" are equivalent to totalfleet / linearfleet & numberfleet respectively.
    (the default quota functions supply their own unit via. an attribute).
  }
  \item{catchability_fs}{
    Either a list of stock names to \link{formula} objects, with an optional unnamed
    default option, or a \link{formula} object (which is always used).
  }
  \item{quota_table}{
    A data.frame with 'biomass' and 'quota' columns,
    'biomass' a numeric column, an upper bound for total biomass amount, the final value always being \code{Inf}.
    'quota' being a list of \code{\link{formula}}s, defining the quota for each, e.g. with \code{\link{g3_parameterized}}.
  }
  \item{sum_stocks}{
    Either a list of \link{g3_stock} objects to sum when choosing a value from \var{quote_table},
    or \code{NULL}, in which case choose the quota based on the current prey.
  }
  \item{recalc_f}{
    A \link{formula} denoting when to recalculate the current quota. For example \code{~cur_step == 1}
    will ensure the quota is only recalculated at the beginning of the year.
  }
  \item{amount_f}{
    Equivalent to \var{E} passed to \link{g3a_predate_catchability_totalfleet}.
  }
  \item{prey_preferences}{
    Either 1, indicating a Type II functional response, or >1 for a Type III functional response.
    Either a list of stock names to numbers, with an optional unnamed
    default option, or a single number to be used for all stocks.
  }
  \item{energycontent}{
    A \link{formula} object for the energy content of the current prey, in in kilojoules per kilogram.
  }
  \item{half_feeding_f}{
    The biomass of prey required to allow the predator to consume prey at half the maximum consumption level.
  }
  \item{max_consumption}{
    A \link{formula} for maximum consumption of the predator, in kilojoules per month.
    Generally generated by \code{\link{g3a_predate_maxconsumption}}
  }
  \item{m0, m1, m2, m3}{
    Parameters for maximum possible consumption formula, see below.
  }
  \item{temperature}{
    A  \link{formula} object for the current temperature, probably generated by \code{\link{g3_timeareadata}}.
  }
  \item{overconsumption_f}{
    Overconsumption rule, a formula that should cap all values in \var{stock__consratio} to <= 95%.
  }
  \item{by_stock}{
    Change the default parameterisation (e.g. to be by 'species'), see \code{\link{g3_parameterized}}.
  }
  \item{by_predator}{
    Change the default parameterisation (e.g. to be by 'species'), see \code{\link{g3_parameterized}}.
  }
  \item{run_f}{
    \link{formula} specifying a condition for running this action, default always runs.
  }
  \item{run_at}{
    Integer order that actions will be run within model, see \code{\link{g3_action_order}}.
  }
}

\details{
  \code{g3a_predate} will, given a \code{\link{g3_fleet}} "predator" and a set of \code{\link{g3_stock}} preys,
  add predation into a model. The behaviour is driven by 2 parameters:

  \describe{
    \item{\var{suitabilities}}{Defines a predator's preference within a prey stock, normally one of the suitability functions, e.g. \code{\link{g3_suitability_exponentiall50}} }
    \item{\var{catchability_f}}{Defines a predator's overall requirements, set with one of the catchability functions, e.g. \code{\link{g3a_predate_catchability_totalfleet}}  }
  }

  For the definition of each catchability function, see the values section below.

  \subsection{Details for custom actions}{
    The actions will define the following stock instance variables for each given \var{fleet_stock} and \var{prey_stock}:
    \describe{
      \item{\var{(predstock)__totalsuit}}{Total suitable prey for (predstock), i.e. \eqn{ \sum_{\it preys}^p \sum_{\it lengths}^l F_{pl}} }
      \item{\var{prey_stock__suit_fleet_stock}}{Suitability of (prey_stock) for (fleet_stock), i.e. \eqn{ F_{pl} } }
      \item{\var{(predstock)_(prey_stock)__cons}}{Biomass of (prey_stock) caught by (predstock), by predator & prey dimensions}
      \item{\var{prey_stock__totalpredate}}{Biomass of total consumed (prey_stock), in a prey array}
      \item{\var{prey_stock__consratio}}{Ratio of prey_stock__totalpredate / (current biomass), capped by \var{overconsumption_f}}
    }

    In addition, \code{g3a_predate_fleet} will generate \var{prey_stock__predby_predstock}, Biomass of (prey_stock) caught by (fleet_stock), in a prey array,
    for compatibility with older models. It is otherwise identical to \code{g3a_predate}.

    A model can have any number of \code{g3a_predate_*} actions, so long as the
    calling arguments are different. For instance, \code{run_f = ~age == 5} and
    \code{run_f = ~age == 7}.
  }
}

\value{
  \subsection{g3a_predate_catchability_totalfleet}{
    \link{formula} objects that define a fleet's desired catch by total biomass (e.g. landings data):
    \deqn{ F_{pl} = S N_{pl} W_{pl} }
    \deqn{ C_{pl} = \frac{E F_{pl}}{\displaystyle \sum_{\it preys}^p \sum_{\it lengths}^l F_{pl}} }
    \describe{
      \item{\eqn{S}}{Suitability form \var{suitabilities} argument}
      \item{\eqn{E}}{\var{E} argument, biomass caught by fleet. Generally a \code{\link{g3_timeareadata}} table containing landings data, with year/step/area/weight columns}
      \item{\eqn{N_{pl}}}{Number of prey in length cell for prey \eqn{p}, length \eqn{l}}
      \item{\eqn{W_{pl}}}{Mean weight of prey in length cell for prey \eqn{p}, length \eqn{l}}
    }
  }

  \subsection{g3a_predate_catchability_numberfleet}{
    \link{formula} objects that define a fleet's desired catch by total number of stock landed (individuals, not biomass):
    \deqn{ F_{pl} = S N_{pl} }
    \deqn{ C_{pl} = \frac{E F_{pl} W_{pl}}{\displaystyle \sum_{\it preys}^p \sum_{\it lengths}^l F_{pl}} }
    \describe{
      \item{\eqn{S}}{Suitability form \var{suitabilities} argument}
      \item{\eqn{E}}{\var{E} argument, numbers caught by fleet. Generally a \code{\link{g3_timeareadata}} table containing landings data, or a constant quota}
      \item{\eqn{N_{pl}}}{Number of prey in length cell for prey \eqn{p}, length \eqn{l}}
      \item{\eqn{W_{pl}}}{Mean weight of prey in length cell for prey \eqn{p}, length \eqn{l}}
    }
  }

  \subsection{g3a_predate_catchability_linearfleet}{
    \link{formula} objects that define a linear relationship between desired catch and available biomass:
    \deqn{ F_{pl} = S N_{pl} W_{pl} }
    \deqn{ C_{pl} = E \Delta t F_{pl} }
    \describe{
      \item{\eqn{S}}{Suitability form \var{suitabilities} argument}
      \item{\eqn{E}}{\var{E} argument, scaling factor for the stock that is to be caught, per month}
      \item{\eqn{\Delta t}}{Length of current step as a proportion of the year, e.g. 0.25. See \code{cur_step_size} in \code{\link{g3a_time}}}
      \item{\eqn{N_{pl}}}{Number of prey in length cell for prey \eqn{p}, length \eqn{l}}
      \item{\eqn{W_{pl}}}{Mean weight of prey in length cell for prey \eqn{p}, length \eqn{l}}
    }
  }

  \subsection{g3a_predate_catchability_project}{
    The formula used depends on the \var{unit} parameter.
    "biomass", "effort", "individuals" are equivalent to totalfleet / linearfleet & numberfleet respectively.
    However, \eqn{E} will switch from landings to quota once the model is projecting.
  }

  \subsection{g3a_predate_catchability_effortfleet}{
    This is a multi-species extension to linearfleet, allowing differently-parameterized catchability per-stock:
    \deqn{ F_{pl} = S N_{pl} W_{pl} }
    \deqn{ C_{pl} = c_{s} E \Delta t F_{pl} }
    \describe{
      \item{\eqn{S}}{Suitability form \var{suitabilities} argument}
      \item{\eqn{c_{s}}}{\var{catchability_fs} argument for the current stock}
      \item{\eqn{E}}{\var{E} argument, scaling factor for the stock that is to be caught, per month}
      \item{\eqn{\Delta t}}{Length of current step as a proportion of the year, e.g. 0.25. See \code{cur_step_size} in \code{\link{g3a_time}}}
      \item{\eqn{N_{pl}}}{Number of prey in length cell for prey \eqn{p}, length \eqn{l}}
      \item{\eqn{W_{pl}}}{Mean weight of prey in length cell for prey \eqn{p}, length \eqn{l}}
    }
  }

  \subsection{g3a_predate_catchability_quotafleet}{
    A \link{formula} onject that defines catch based on the available biomass of the stock multiplied by a scaling factor set according to a simple harvest control rule:
    \deqn{ F_{pl} = S N_{pl} W_{pl} }
    \deqn{ C_{pl} = q E \Delta t F_{pl} }
    \describe{
      \item{\eqn{q}}{
        quota selected from \var{quota_table}, corresponding to the total biomass of \var{sum_stocks}.
        For example, given \code{data.frame(biomass = c(10000, Inf), quota = I(list(g3_parameterized('quota.low'), g3_parameterized('quota.high'))))},
        'quota.low' will be chosen when total biomass is less than 10000, otherwise 'quota.high' will be used.
        }
      \item{\eqn{S}}{Suitability form \var{suitabilities} argument}
      \item{\eqn{E}}{\var{E} argument, scaling factor for the stock that is to be caught, per month}
      \item{\eqn{\Delta t}}{Length of current step as a proportion of the year, e.g. 0.25. See \code{cur_step_size} in \code{\link{g3a_time}}}
      \item{\eqn{N_{pl}}}{Number of prey in length cell for prey \eqn{p}, length \eqn{l}}
      \item{\eqn{W_{pl}}}{Mean weight of prey in length cell for prey \eqn{p}, length \eqn{l}}
    }
    ...if \var{recalc_f} is set, this will only be recaculated when true. Any other step
    will use the previous value.
  }

  \subsection{g3a_predate_maxconsumption}{
    \link{formula} objects that define a predator's maximum consumption:
    \deqn{ M_{L} = m_0 \Delta t e^{(m_1T-m_2T^3)} L^{m_3}  }
    \describe{
      \item{\eqn{m_x}}{\var{mx} parameter, for \eqn{M_L}, maximum possible consumption for the predator on the current timestep}
      \item{\eqn{\Delta t}}{Length of current step as a proportion of the year, e.g. 0.25. See \code{cur_step_size} in \code{\link{g3a_time}}}
      \item{\eqn{T}}{\var{temperature} parameter, formula representing current temperature}
    }
  }

  \subsection{g3a_predate_catchability_predator}{
    \link{formula} objects that define the predator/prey relationship:
    \deqn{ F_{pl} = (S E_{p} N_{pl} W_{pl})^{d_p} }
    \deqn{ C_{pl} = \frac{ N_{L} M_{L} \psi_L F_{pl} }{ E_{p} \displaystyle \sum_{\it preys}^p \sum_{\it lengths}^l F_{pl} } }
    \deqn{ \psi_{L} = \frac{ \displaystyle \sum_{\it preys}^p \sum_{\it lengths}^l F_{pl} }{ H \Delta t + \displaystyle \sum_{\it preys}^p \sum_{\it lengths}^l F_{pl} } }
    \describe{
      \item{\eqn{S}}{Suitability form \var{suitabilities} argument}
      \item{\eqn{\Delta t}}{Length of current step as a proportion of the year, e.g. 0.25. See \code{cur_step_size} in \code{\link{g3a_time}}}
      \item{\eqn{N_{pl}}}{Number of prey in length cell for prey \eqn{p}, length \eqn{l}}
      \item{\eqn{W_{pl}}}{Mean weight of prey in length cell for prey \eqn{p}, length \eqn{l}}
      \item{\eqn{M_L}}{Maximum possible consumption for the predator on the current timestep, in in kilojoules per month. See \code{\link{g3a_predate_maxconsumption}}}
      \item{\eqn{L}}{Length of the current predator}
      \item{\eqn{E_p}}{\var{energycontent} parameter, the energy content of prey}
      \item{\eqn{H}}{\var{half_feeding_f} parameter, the biomass of prey required to allow the predator to consume prey at half the maximum consumption level}
      \item{\eqn{T}}{\var{temperature} parameter, formula representing current temperature}
    }
  }

  \subsection{g3a_predate}{An action (i.e. list of formula objects) that will...\enumerate{
    \item{For each prey, collect all suitable stock into a \var{predstock_prey_stock__suit} variable, using the \var{catchability_f} \eqn{F_pl} formula. The units here will depend on the \var{catchability_f} method used.}
    \item{After all predator consumption is done, scale consumption using the \var{catchability_f} \eqn{C_pl} formula into \var{predstock_prey_stock__cons}, summed into \var{prey_stock__totalpredate}}
    \item{Calculate \var{prey_stock__consratio} (ratio of consumed to available), capping using \var{overconsumption_f}. Update \var{prey_stock__num}}
    \item{Recalculate \var{predstock_prey_stock__cons}, \var{predstock_prey_stock__suit}, post-overconsumption}
  }}
}

\seealso{
  \url{https://gadget-framework.github.io/gadget2/userguide/chap-stock.html#sec:stockpredator},
  \code{\link{g3_stock}}
}

\examples{
\dontshow{library(magrittr)}
areas <- c(a = 1, b = 2)
ling_imm <- g3_stock(c(species = 'ling', 'imm'), seq(20, 156, 4)) \%>\% g3s_age(3, 10)
ling_mat <- g3_stock(c(species = 'ling', 'mat'), seq(20, 156, 4)) \%>\% g3s_age(5, 15)
lln <- g3_fleet('lln') \%>\% g3s_livesonareas(areas[c('a', 'b')])

# Invent a lln_landings table
lln_landings <- expand.grid(
    year = 1999:2000,
    step = c(1, 2),
    area = areas[c('a', 'b')])
lln_landings$total_weight <- floor(runif(nrow(lln_landings), min=100, max=999))

# g3a_predate_catchability_totalfleet(): Set catch accordings to landings data
predate_action <- g3a_predate_fleet(
    lln,
    list(ling_imm, ling_mat),
    suitabilities = g3_suitability_exponentiall50(by_stock = 'species'),
    catchability_f = g3a_predate_catchability_totalfleet(
        g3_timeareadata('lln_landings', lln_landings, "total_weight") ))

# g3a_predate_catchability_numberfleet(): Fixed quota of 1000 fish
predate_action <- g3a_predate_fleet(
    lln,
    list(ling_imm, ling_mat),
    suitabilities = g3_suitability_exponentiall50(by_stock = 'species'),
    catchability_f = g3a_predate_catchability_numberfleet(
        g3_parameterized(
            'quota',
            value = 1000,
            by_predator = TRUE,
            scale = 0.5,
            optimise = FALSE) ))
attr(suppressWarnings(g3_to_r(list(predate_action))), 'parameter_template')
}
