% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_identify.R
\name{identify.data_request}
\alias{identify.data_request}
\alias{identify.metadata_request}
\alias{galah_identify}
\title{Narrow a query by passing taxonomic identifiers}
\usage{
\method{identify}{data_request}(x, ...)

\method{identify}{metadata_request}(x, ...)

galah_identify(...)
}
\arguments{
\item{x}{An object of class \code{data_request} or \code{metadata_request}.}

\item{...}{One or more scientific names.}
}
\value{
A \code{tibble} containing identified taxa.
}
\description{
When conducting a search or creating a data query, it is common to identify
a known taxon or group of taxa to narrow down the records or results returned.
\code{identify()} is used to identify taxa you want returned in a search or
a data query. Users to pass scientific names or taxonomic identifiers
with pipes to provide data only for the biological group of interest.

It is good to use \code{\link[=search_taxa]{search_taxa()}} and \code{\link[=search_identifiers]{search_identifiers()}}
first to check that the taxa you provide to \code{galah_identify()} return the
correct results.
}
\examples{
\dontrun{
# Use `galah_identify()` to narrow your queries
galah_call() |> 
  identify("Eolophus") |>
  count() |>
  collect()

# If you know a valid taxon identifier, use `filter()` instead.
id <- "https://biodiversity.org.au/afd/taxa/009169a9-a916-40ee-866c-669ae0a21c5c"
galah_call() |> 
  filter(lsid == id)  |>
  count() |>
  collect()
}
}
\seealso{
\code{\link[=filter.data_request]{filter()}} or \code{\link[=geolocate]{geolocate()}} for
other ways to filter a query. You can also use \code{\link[=search_taxa]{search_taxa()}} to check that
supplied names are being matched correctly on the server-side; see
\link{taxonomic_searches} for a detailed overview.
}
