% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cormat.R
\name{arma.cormat}
\alias{arma.cormat}
\title{ARMA Correlation Structure for Copula Time Series}
\usage{
arma.cormat(p = 0, q = 0, tau.lower = NULL, tau.upper = NULL)
}
\arguments{
\item{p}{Integer. AR order (non-negative).}

\item{q}{Integer. MA order (non-negative).}

\item{tau.lower}{Optional vector of lower bounds for the ARMA parameters.}

\item{tau.upper}{Optional vector of upper bounds for the ARMA parameters.}
}
\value{
An object of class \code{"arma.gctsc"} and \code{"cormat.gctsc"}, containing:
\item{npar}{Number of ARMA parameters.}
\item{od}{A length-2 vector \code{c(p, q)} giving the AR and MA order.}
\item{start}{Function to compute starting values from data using \code{\link[stats]{arima}}.}
}
\description{
Constructs a correlation structure object for use in Gaussian copula time series models
with autoregressive moving average (ARMA) dependence.
}
\seealso{
\code{\link{gctsc}}, \code{\link{poisson.marg}}, \code{\link{predict.gctsc}}
}
