% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik_ghk.R
\name{pmvn_ghk}
\alias{pmvn_ghk}
\title{GHK Log-Likelihood Approximation}
\usage{
pmvn_ghk(lower, upper, tau, od, M = 1000, QMC = TRUE, ret_llk = TRUE)
}
\arguments{
\item{lower}{A numeric vector of lower truncation bounds.}

\item{upper}{A numeric vector of upper truncation bounds.}

\item{tau}{A numeric vector of ARMA dependence parameters.}

\item{od}{Integer vector \code{c(p, q)} specifying the AR and MA orders.}

\item{M}{Integer. Number of Monte Carlo or QMC samples.}

\item{QMC}{Logical. If \code{TRUE}, use quasi-Monte Carlo integration.}

\item{ret_llk}{Logical. Default is \code{TRUE} to return log-likelihood; otherwise, return diagnostic output.}
}
\value{
If \code{ret_llk = TRUE}, a numeric scalar (log-likelihood); else a list containing diagnostic statistics.
}
\description{
Computes the approximate log-likelihood for a count time series model using
the Geweke–Hajivassiliou–Keane (GHK) simulator. This method evaluates
the multivariate normal rectangle probability by sequentially sampling
from truncated conditionals implied by the ARMA Gaussian copula.
}
\examples{
# Simulate Poisson AR(1) data
mu=10
tau=0.2
arma_order=c(1,0)
sim_data <- sim_poisson(mu =mu, tau=tau, arma_order=arma_order, nsim = 1000, seed = 1)
y <- sim_data$y

# Compute latent bounds for CE method
a <- qnorm(ppois(y - 1, lambda = mu))  # lower bound
b <- qnorm(ppois(y, lambda = mu))      # upper bound
# Approximate log-likelihood with CE method
llk_tmet <- pmvn_ghk(lower = a, upper = b, tau = 0.2, od = c(1,0))
print(llk_tmet)

}
