% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_quasirandom_interactive.R
\name{geom_quasirandom_interactive}
\alias{geom_quasirandom_interactive}
\title{Create interactive quasirandom geom}
\usage{
geom_quasirandom_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggbeeswarm:geom_quasirandom]{ggbeeswarm::geom_quasirandom()}}.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive repulsive texts to a ggplot -------
library(ggplot2)
library(ggiraph)

# geom_text_repel_interactive
if (
  requireNamespace("ggbeeswarm", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)
) {
  set.seed(2)

  dat <- dplyr::filter(
    .data = diamonds,
    cut \%in\% c("Fair", "Good"),
    color \%in\% c("D", "E", "H")
  )
  dat <- dplyr::sample_n(tbl = dat, 150)

  dodge_width <- .8
  position <- position_dodge(width = dodge_width)

  gg_qr <- ggplot(dat, aes(x = cut, y = y, fill = color)) +
    geom_violin(
      alpha = .5,
      width = dodge_width
    ) +
    geom_boxplot(position = position, alpha = .5, outliers = FALSE) +
    geom_quasirandom_interactive(
      aes(tooltip = y, data_id = color),
      shape = 21,
      size = 2,
      dodge.width = dodge_width,
      color = "black",
      alpha = .5
    ) +
    theme_minimal()

  x <- girafe(ggobj = gg_qr)
  x <- girafe_options(x = x, opts_hover(css = "fill:#FF4C3B;"))
  if (interactive()) print(x)




  dat <- mtcars
  dat$name <- row.names(mtcars)
  dat$am <- factor(dat$am)
  dat$gear <- factor(dat$gear)

  dodge_width <- .8
  position <- position_dodge(width = dodge_width)

  gg_qr <- ggplot(
    dat,
    aes(x = am, y = disp, fill = gear, group = interaction(am, gear))
  ) +
    geom_quasirandom_interactive(
      aes(tooltip = disp, data_id = name),
      shape = 21,
      size = 2,
      dodge.width = dodge_width,
      color = "black"
    ) +
    scale_fill_manual_interactive(
      name = label_interactive(
        "Gearrrrrr",
        tooltip = "Gearrrrrr",
        data_id = "gear"
      ),
      values = c("3" = "#0072B2", "4" = "#009E73", "5" = "red"),
      data_id = c("3" = "tree", "4" = "tree", "5" = "four"),
      tooltip = c("3" = "tree", "4" = "tree", "5" = "four")
    ) +
    theme_minimal()

  x <- girafe(ggobj = gg_qr)
  if (interactive()) print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
