% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_abs}
\alias{ggml_abs}
\title{Absolute Value (Graph)}
\usage{
ggml_abs(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the abs operation
}
\description{
Creates a graph node for element-wise absolute value: |x|
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(-2, -1, 1, 2))
result <- ggml_abs(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)  # [2, 1, 1, 2]
ggml_free(ctx)
}
}
