% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-brain.R
\name{scale_brain_manual}
\alias{scale_brain_manual}
\alias{scale_colour_brain_manual}
\alias{scale_color_brain_manual}
\alias{scale_fill_brain_manual}
\title{Manual colour and fill scales for brain plots}
\usage{
scale_brain_manual(
  palette,
  na.value = "grey",
  ...,
  aesthetics = c("fill", "colour", "color")
)

scale_colour_brain_manual(...)

scale_color_brain_manual(...)

scale_fill_brain_manual(...)
}
\arguments{
\item{palette}{Named character vector mapping region names to colours.}

\item{na.value}{Colour for `NA` entries (default: `"grey"`).}

\item{...}{Additional arguments (unused).}

\item{aesthetics}{Which aesthetic to scale: `"fill"`, `"colour"`, or
`"color"`.}
}
\value{
A ggplot2 scale object.
}
\description{
Apply a custom named colour palette to brain atlas plots. Use this
when you want to override the atlas default colours with your own
colour mapping.
}
\examples{
library(ggplot2)

pal <- c("insula" = "red", "precentral" = "blue")
ggplot() +
  geom_brain(atlas = dk(), aes(fill = region), show.legend = FALSE) +
  scale_fill_brain_manual(palette = pal)

}
