% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproduce_metadata.R
\name{reproduce_network}
\alias{reproduce_network}
\title{Reproduce a network visualization from metadata}
\usage{
reproduce_network(
  metadata = NULL,
  group_id = NULL,
  object = NULL,
  zoom_level = 1.2
)
}
\arguments{
\item{metadata}{Either a metadata object or a file path to an RDS file
containing metadata captured from the Shiny app. If NULL, the function
will stop with an error.}

\item{group_id}{The identifier for the specific network group to reproduce.
This corresponds to the group ID used in the original Shiny app.}

\item{object}{Optional network object to use instead of the one stored
in metadata. Useful for testing with different network objects.}

\item{zoom_level}{Zoom factor for the visualization. Default is 1.2.}
}
\value{
A ggplot object containing the reproduced network visualization.
}
\description{
This function recreates a network visualization using stored metadata from
a Shiny app session. It can handle various network object types including
igraph, qgraph, ggnet2 objects, and adjacency matrices.
}
\examples{
\dontrun{
# Reproduce network from saved metadata
network_plot <- reproduce_network(
  metadata = "path/to/metadata.rds",
  group_id = "network1"
)

# Reproduce with custom data
network_plot <- reproduce_network(
  metadata = metadata_object,
  data = "path/to/edges.csv",
  group_id = "network1"
)
}
}
