% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-dable.R
\name{autoplot.dcmp_ts}
\alias{autoplot.dcmp_ts}
\title{Decomposition plots}
\usage{
\method{autoplot}{dcmp_ts}(object, .vars = NULL, scale_bars = TRUE, level = c(80, 95), ...)
}
\arguments{
\item{object}{A dable.}

\item{.vars}{The column of the dable used to plot. By default, this will be the response variable of the decomposition.}

\item{scale_bars}{If \code{TRUE}, each facet will include a scale bar which represents the same units across each facet.}

\item{level}{If the decomposition contains distributions, which levels should be used to display intervals?}

\item{...}{Further arguments passed to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}, which can be used to specify fixed aesthetics such as \code{colour = "red"} or \code{size = 3}.}
}
\value{
A ggplot object showing a set of time plots of the decomposition.
}
\description{
Produces a faceted plot of the components used to build the response
variable of the dable. Useful for visualising how the components contribute
in a decomposition or model.
}
\examples{
\dontshow{if (requireNamespace("feasts", quietly = TRUE) && requireNamespace("tsibbledata", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(fabletools)
library(feasts)
tsibbledata::aus_production \%>\%
  model(STL(Beer)) \%>\%
  components() \%>\%
  autoplot()
\dontshow{\}) # examplesIf}
}
