% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree-discrpar.R
\name{discrpar_grmtree}
\alias{discrpar_grmtree}
\title{Extract Discrimination Parameters from GRM Tree}
\usage{
discrpar_grmtree(object, node = NULL, ...)
}
\arguments{
\item{object}{A \code{grmtree} object.}

\item{node}{Optional vector of node IDs to extract from. If NULL (default),
extracts from all terminal nodes.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data.frame with discrimination parameters for each item in each
node, with columns: \item{Node}{Node ID} \item{Item}{Item name}
\item{Discrimination}{Discrimination parameter (a1)}
}
\description{
Extracts discrimination parameters (slope parameters) for each item from all
terminal nodes of a graded response model tree. The discrimination parameter
indicates how well an item distinguishes between respondents with different
levels of the latent trait.
}
\examples{
\donttest{
  library(grmtree)
  library(hlt)
  data("asti", package = "hlt")
  asti$resp <- data.matrix(asti[, 1:4])

  # Fit GRM tree with gender and group as partitioning variables
  tree <- grmtree(resp ~ gender + group,
          data = asti,
          control = grmtree.control(minbucket = 30))

  # Get all discrimination parameters
  discr <- discrpar_grmtree(tree)
  print(discr)

}

}
\seealso{
\code{\link{grmtree}} fits a Graded Response Model Tree,
\code{\link{grmforest}} for GRM Forests, \code{\link{fscores_grmtree}} for
computing factor scores, \code{\link{threshpar_grmtree}} for extracting
threshold parameters, \code{\link{itempar_grmtree}} for extracting item
parameters
}
