% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt-bar-html.R
\name{gt_plt_bar_pct}
\alias{gt_plt_bar_pct}
\title{Add HTML-based bar plots into rows of a \code{gt} table}
\usage{
gt_plt_bar_pct(
  gt_object,
  column,
  height = 16,
  width = 100,
  fill = "purple",
  background = "#e1e1e1",
  scaled = FALSE,
  labels = FALSE,
  label_cutoff = 0.4,
  decimals = 1,
  font_style = "bold",
  font_size = "10px"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the bar plot should replace existing data.}

\item{height}{A number representing the vertical height of the plot in pixels. Defaults to 16 px.}

\item{width}{A number representing the horizontal width of the plot in pixels. Defaults to 100 px. Importantly, this interacts with the label_cutoff argument, so if you want to change the cutoff, you may need to adjust the width as well.}

\item{fill}{A character representing the fill for the bar, defaults to purple. Accepts a named color (eg 'purple') or a hex color.}

\item{background}{A character representing the background filling out the 100\% mark of the bar, defaults to light grey. Accepts a named color (eg 'white') or a hex color.}

\item{scaled}{\code{TRUE}/\code{FALSE} logical indicating if the value is already scaled to a percent of max (\code{TRUE}) or if it needs to be scaled (\code{FALSE}). Defaults to \code{FALSE}, meaning the value will be divided by the max value in that column and then multiplied by 100.}

\item{labels}{\code{TRUE}/\code{FALSE} logical representing if labels should be plotted. Defaults to \code{FALSE}, meaning that no value labels will be plotted.}

\item{label_cutoff}{A number, 0 to 1, representing where to set the inside/outside label boundary. Defaults to 0.40 (40\%) of the column's maximum value. If the value in that row is less than the cutoff, the label will be placed outside the bar, otherwise it will be placed within the bar. This interacts with the overall width of the bar, so if you are not happy with the placement of the labels you may try adjusting the \code{width} argument as well.}

\item{decimals}{A number representing how many decimal places to be used in label rounding. Defaults to 1.}

\item{font_style}{A character representing the font style of the labels. Accepts one of 'bold' (default), 'italic', or 'normal'.}

\item{font_size}{A character representing the font size of the labels. Defaults to '10px'.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_plt_bar_pct} function takes an existing \code{gt_tbl} object and
adds horizontal barplots via native HTML. Note that values
default to being normalized to the percent of the maximum observed value
in the specified column. You can turn this off if the values already
represent a percentage value representing 0-100.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)

base_tab <- dplyr::tibble(x = seq(1, 100, length.out = 6)) \%>\%
  dplyr::mutate(
    x_unscaled = x,
    x_scaled = x / max(x) * 100
  ) \%>\%
  gt()

base_tab \%>\%
  gt_plt_bar_pct(
    column = x_unscaled,
    scaled = TRUE,
    fill = "forestgreen"
  ) \%>\%
  gt_plt_bar_pct(
    column = x_scaled,
    scaled = FALSE,
    labels = TRUE
  )
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_bar_plot.png}{options: width=500}}
}

\section{Function ID}{

3-5
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_sparkline}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
