% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_attr_names}
\alias{h5_attr_names}
\title{List HDF5 Attributes}
\usage{
h5_attr_names(file, name = "/")
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The path to the object (dataset or group) to query.
Use \code{/} for the file's root attributes.}
}
\value{
A character vector of attribute names.
}
\description{
Lists the names of attributes attached to a specific HDF5 object.
}
\examples{
file <- tempfile(fileext = ".h5")

h5_write(1:10,          file, "data")
h5_write(I("meters"),   file, "data", attr = "unit")
h5_write(I(Sys.time()), file, "data", attr = "timestamp")

h5_attr_names(file, "data") # "unit" "timestamp"

unlink(file)
}
\seealso{
\code{\link[=h5_ls]{h5_ls()}}
}
