% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_is_dataset}
\alias{h5_is_dataset}
\title{Check if an HDF5 Object is a Dataset}
\usage{
h5_is_dataset(file, name, attr = NULL)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The full path of the object to check.}

\item{attr}{The name of an attribute. If provided, the function returns \code{TRUE} if the attribute exists,
as all attributes are considered datasets in HDF5 context. (Default: \code{NULL})}
}
\value{
A logical value: \code{TRUE} if the object exists and is a dataset,
\code{FALSE} otherwise (if it is a group, or does not exist).
}
\description{
Checks if the object at a given path is a dataset.
}
\examples{
file <- tempfile(fileext = ".h5")

h5_write(1, file, "dset")
h5_is_dataset(file, "dset") # TRUE

h5_create_group(file, "grp")
h5_is_dataset(file, "grp") # FALSE

h5_write(1, file, "grp", attr = "my_attr")
h5_is_dataset(file, "grp", "my_attr") # TRUE

unlink(file)
}
\seealso{
\code{\link[=h5_is_group]{h5_is_group()}}, \code{\link[=h5_exists]{h5_exists()}}
}
