% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmo_sax.R
\name{hmo_sax}
\alias{hmo_sax}
\title{Motif discovery using SAX}
\usage{
hmo_sax(a, w, qtd = 2)
}
\arguments{
\item{a}{Integer. Alphabet size.}

\item{w}{Integer. Word/window size.}

\item{qtd}{Integer. Minimum number of occurrences to classify as a motif.}
}
\value{
\code{hmo_sax} object.
}
\description{
Discovers repeated subsequences (motifs) using a Symbolic Aggregate approXimation
(SAX) representation \url{doi:10.1007/s10618-007-0064-z}. Subsequences are discretized
and grouped by symbolic words; frequently occurring words indicate motifs.
}
\examples{
library(daltoolbox)

# Load motif example data
data(examples_motifs)

# Use a simple sequence example
dataset <- examples_motifs$simple
head(dataset)

# Configure SAX-based motif discovery
model <- hmo_sax(26, 3, 3)

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected motifs
print(detection[(detection$event),])

}
\references{
\itemize{
\item Lin J, Keogh E, Lonardi S, Chiu B (2007). A symbolic representation of time series,
with implications for streaming algorithms. Data Mining and Knowledge Discovery 15, 107–144.
}
}
