% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_mdi.R
\name{prepare_mdi}
\alias{prepare_mdi}
\title{Create the BEST-COST Multidimensional Deprivation Index (MDI)}
\usage{
prepare_mdi(
  geo_id_micro,
  edu,
  unemployed,
  single_parent,
  pop_change,
  no_heating,
  n_quantile,
  verbose = TRUE
)
}
\arguments{
\item{geo_id_micro}{\code{Numeric vector} or \code{string vector} specifying the unique ID codes of each geographic area considered in the assessment (\code{geo_id_micro}).}

\item{edu}{\code{Numeric vector} indicating educational attainment as \% of individuals
(at the age 18 or older) without a high school diploma (ISCED 0-2) per geo unit}

\item{unemployed}{\code{Numeric vector} containing \% of unemployed individuals in the active
population (18-65) per geo unit}

\item{single_parent}{\code{Numeric vector} containing single-parent households as \% of total
households headed by a single parent per geo unit}

\item{pop_change}{\code{Numeric vector} containing population change as \% change in population
over the previous 5 years (e.g., 2017-2021) per geo unit}

\item{no_heating}{\code{Numeric vector} containing \% of households without central heating per
geo unit}

\item{n_quantile}{\code{Integer value} specifying the number of quantiles in the analysis.}

\item{verbose}{\code{Boolean} indicating whether function output is printed to console.
Default: \code{TRUE}.}
}
\value{
This function returns a \code{list} containing

1) \code{mdi_main} (\code{tibble}) with the columns (selection);
\itemize{
  \item \code{geo_id_micro} containing the \code{numeric} geo id's
  \item \code{MDI} containing the \code{numeric} BEST-COST Multidimensional Deprivation Index values
  \item \code{MDI_index} \code{numeric} decile based on values in the column \code{MDI}
  \item additional columns containing the function input data
}

2) \code{mdi_detailed} (\code{list}) with several elements for the internal consistency check of the BEST-COST
  Multidimensional Deprivation Index.
\itemize{
  \item \code{boxplot} (\code{language}) containing the code to reproduce the boxplot of the single indicators
  \item \code{histogram} (\code{language}) containing the code to reproduce a histogram of the BEST-COST
  Multidimensional Deprivation Index (MDI) values with a normal distribution curve
  \item \code{descriptive_statistics} (\code{list} table of descriptive statistics (mean, SD, min, max) of the normalized input data and the MDI
  \item \code{cronbachs_alpha_value} (\code{numeric value} See the Details section for the reliability rating this value indicates
  \item \code{pearsons_corr_coeff} (\code{numeric vector}) Person's correlation coefficient (pairwise-comparisons)
}
}
\description{
This function creates the BEST-COST Multidimensional Deprivation Index (MDI) and checks internal
consistency of the single deprivation indicators using Cronbach's coefficient \eqn{\alpha} and
other internal consistency checks
}
\details{
\strong{Methodology}

This function condenses socio-economic indicators into
a multiple deprivation index (MDI) \insertCite{Mogin2025_ejph}{healthiar}.
The reliability of the MDI is assessed using Cronbach's alpha \insertCite{Cronbach1951_p}{healthiar}.

Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#multiple-deprivation-index}{Multiple deprivation index}}


\strong{Data completeness and imputation}

Ensure the data set is as complete as possible. Otherwise, you can try to impute missing data,
but R^2 should be greater than or equal to 0.7.

\strong{Plots}

See the example below for how to reproduce the box plots and
the histogram after the \code{prepare_mdi} function call.
}
\examples{
# Goal: create the BEST-COST Multidimensional Deprivation Index for
# a selection of geographic units

results <- prepare_mdi(
  geo_id_micro = exdat_prepare_mdi$id,
  edu = exdat_prepare_mdi$edu,
  unemployed = exdat_prepare_mdi$unemployed,
  single_parent = exdat_prepare_mdi$single_parent,
  pop_change = exdat_prepare_mdi$pop_change,
  no_heating = exdat_prepare_mdi$no_heating,
  n_quantile = 10,
  verbose = TRUE
)

results$mdi_main |>
  dplyr::select(geo_id_micro, MDI, MDI_index) |>
  dplyr::slice(1:15)

# Reproduce plots after the function call
eval(results$mdi_detailed$boxplot)
eval(results$mdi_detailed$histogram)


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Downstream: \code{\link{socialize}}
}
}
\author{
Carl Baravelli, Vanessa Gorasso, Alberto Castro & Axel Luyten
}
