% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize}
\alias{standardize}
\title{Obtain age-standardized health impacts}
\usage{
standardize(output_attribute, age_group, ref_prop_pop = NULL)
}
\arguments{
\item{output_attribute}{\code{List} containing the outputs of the \code{healthiar::attribute_health()} assessments for each age group (each list element should be an age group-specific assessment).}

\item{age_group}{\code{String vector} with the age groups included in the age standardization. The vector refers to age-dependent data in this function and to \code{output_attribute} (if provided).}

\item{ref_prop_pop}{\code{Numeric vector} specifying with the reference proportion of population for each age group. If this argument is empty, the proportion of \code{population} by age group in the provided data will be used.}
}
\value{
This function returns a \code{list} containing:

1) \code{health_main} (\code{tibble}) containing the age-standardized main results;

2) \code{health_detailed} (\code{tibble}) containing the results per age group.
}
\description{
This function obtains age-standardized health impacts based on multiple age-group specific assessments
}
\details{
\strong{Methodology}

This function applies the direct method of standardization,
where the age-specific rates observed in a study population are
applied to a standard (reference) population distribution.

For age standardization in health impact assessments,
the World Health Organization \insertCite{Ahmad2001_report}{healthiar} and
the Global Burden of Disease study \insertCite{GBD2020_tldemo}{healthiar}
provide the relevant information on this topic.


Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#standardization}{Standardization}}

This function works after running \code{attribute_health()} or \code{attribute_lifetable()} functions.
If you want to use it in combination with compare(),
please standardize first the results of attribute functions and then compare.
}
\examples{
# Goal: age-standardize two age group-specific impacts
output_attribute <- attribute_health(
  rr_central = 1.063,
  rr_increment = 10,
  erf_shape = "log_linear",
  cutoff_central =  0,
  age_group = c("below_40", "above_40"),
  exp_central = c(8.1, 10.9),
  bhd_central = c(1000, 4000),
  population = c(100000, 500000)
)
results <- standardize(
  output_attribute = output_attribute,
  age_group = c("below_40", "above_40"),
  ref_prop_pop = c(0.5, 0.5)
)
results$health_detailed$results_raw$impact_per_100k_inhab # age group-specific impact rate
results$health_main$impact_per_100k_inhab # age-standardized impact rate


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream:
    \code{\link{attribute_health}}, \code{\link{attribute_lifetable}}
}
}
\author{
Alberto Castro & Axel Luyten
}
