% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dogfood}
\alias{dogfood}
\title{Dogfood Preferences}
\format{
A data frame with 16 observations on the following 3 variables.
\describe{
\item{\code{formula}}{factor, a factor with levels \code{Old}, \code{New}, \code{Major}, \code{Alps}}
\item{\code{start}}{numeric, time to start eating}
\item{\code{amount}}{numeric, amount eaten}
}
}
\source{
Used in my Psych 6140 lecture notes, \url{http://friendly.apps01.yorku.ca/psy6140/}
}
\usage{
data("dogfood")
}
\description{
A tiny hypothetical dataset to illustrate one-way MANOVA.

A dogfood manufacturer wanted to study preference for different dogfood formulas, two of their own
("Old", "New") and two from other manufacturers ("Major", "Alps"). In a between-dog design, 4 dogs
were presented with a bowl of one \code{formula} and the time to \code{start} eating and \code{amount} eaten were recorded.
}
\details{
In addition to testing the overall effects of \code{formula},
three useful (and orthogonal) contrasts can specified for this 3-df factor:
\itemize{
\item \code{Ours} vs. \code{Theirs}, with weights \code{c(1, 1, -1, -1)}
\item \code{Major} vs. \code{Alps}, with weights \code{c(0, 0,  1, -1)}
\item \code{Old} vs. \code{New}, with weights \code{c(1, -1, 0, 0)}
}
Because these are orthogonal contrasts, they fully decompose the main effect of \code{formula},
in that their sum of squares add to the overall sum of squares.
}
\examples{
data(dogfood)
library(car)
library(candisc)

# make some boxplots
op <- par(mfrow = c(1,2))
boxplot(start ~ formula, data = dogfood)
points(start ~ formula, data = dogfood, pch=16, cex = 1.2)

boxplot(amount ~ formula, data = dogfood)
points(amount ~ formula, data = dogfood, pch=16, cex = 1.2)
par(op)

# setup contrasts to test interesting comparisons
C <- matrix(
       c( 1,  1, -1, -1,         #Ours vs. Theirs
          0,  0,  1, -1,           #Major vs. Alps
          1, -1,  0,  0),             #New vs. Old
       nrow=4, ncol=3)
# assign these to the formula factor
contrasts(dogfood$formula) <- C
# re-fit the model
dogfood.mod <- lm(cbind(start, amount) ~ formula, data=dogfood)

dogfood.mod <- lm(cbind(start, amount) ~ formula, data=dogfood)
Anova(dogfood.mod)

# data ellipses
covEllipses(cbind(start, amount) ~ formula, data=dogfood,
  fill = TRUE, fill.alpha = 0.1)

# test these contrasts with multivariate tests 
linearHypothesis(dogfood.mod, "formula1", title="Ours vs. Theirs")
linearHypothesis(dogfood.mod, "formula2", title="Old vs. New")
linearHypothesis(dogfood.mod, "formula3", title="Alps vs. Major")

heplot(dogfood.mod, fill = TRUE, fill.alpha = 0.1)

# display contrasts in the heplot 
hyp <- list("Ours/Theirs" = "formula1",
            "Old/New" = "formula2")
heplot(dogfood.mod, hypotheses = hyp,
       fill = TRUE, fill.alpha = 0.1)

dogfood.can <- candisc(dogfood.mod, data=dogfood)
heplot(dogfood.can, 
       fill = TRUE, fill.alpha = 0.1, 
       lwd = 2, var.lwd = 2, var.cex = 2)
}
\concept{MANOVA}
\concept{candisc}
\concept{contrasts}
\keyword{datasets}
