% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etasq.R
\name{etasq}
\alias{etasq}
\alias{etasq.lm}
\alias{etasq.mlm}
\alias{etasq.Anova.mlm}
\title{Measures of Partial Association (\eqn{\eta^2}) for Linear Models}
\usage{
etasq(x, ...)

\method{etasq}{mlm}(x, ...)

\method{etasq}{Anova.mlm}(x, anova = FALSE, ...)

\method{etasq}{lm}(x, anova = FALSE, partial = TRUE, ...)
}
\arguments{
\item{x}{A \code{lm}, \code{mlm} or \code{Anova.mlm} object}

\item{\dots}{Other arguments passed down to \code{\link[car]{Anova}}.}

\item{anova}{A logical, indicating whether the result should also contain
the test statistics produced by \code{Anova()}.}

\item{partial}{A logical, indicating whether to calculate partial or
classical eta^2.}
}
\value{
When \code{anova=FALSE}, a one-column data frame containing the
eta-squared values for each term in the model.

When \code{anova=TRUE}, a 5-column (lm) or 7-column (mlm) data frame
containing the eta-squared values and the test statistics produced by
\code{print.Anova()} for each term in the model.
}
\description{
Calculates partial eta-squared for linear models or multivariate analogs of
eta-squared (or R^2), indicating the partial association for each term in a
multivariate linear model. For a multivariate model, this is a summary
across all response variables.
}
\details{
There is a different analog of \eqn{\eta^2} for each of the four
standard multivariate test statistics: Pillai's trace, Hotelling-Lawley
trace, Wilks' Lambda and Roy's maximum root test.

For univariate linear models, classical
\eqn{\eta^2} = SSH / SST and partial
\eqn{\eta^2} = SSH / (SSH + SSE).  These are identical in one-way designs.

Partial eta-squared describes the proportion of total variation attributable
to a given factor, partialling out (excluding) other factors from the total
nonerror variation. These are commonly used as measures of effect size or
measures of (non-linear) strength of association in ANOVA models.

All multivariate tests are based on the \eqn{s=min(p, df_h)} latent roots of
\eqn{H E^{-1}}. The analogous multivariate partial \eqn{\eta^2} measures are
calculated as:

\describe{
\item{Pillai's trace (V)}{\eqn{\eta^2 = V/s}}
\item{Hotelling-Lawley trace (T)}{\eqn{\eta^2 = T/(T+s)}}
\item{Wilks' Lambda (L)}{\eqn{\eta^2 = L^{1/s}}}
\item{Roy's maximum root (R)}{\eqn{\eta^2 = R/(R+1)}}
}
}
\examples{

library(car)
data(Soils, package="carData")
soils.mod <- lm(cbind(pH,N,Dens,P,Ca,Mg,K,Na,Conduc) ~ Block + Contour*Depth, data=Soils)
#Anova(soils.mod)
etasq(Anova(soils.mod))
etasq(soils.mod) # same
etasq(Anova(soils.mod), anova=TRUE)

etasq(soils.mod, test="Wilks")
etasq(soils.mod, test="Hotelling")

}
\references{
Muller, K. E. and Peterson, B. L. (1984). Practical methods for
computing power in testing the Multivariate General Linear Hypothesis
\emph{Computational Statistics and Data Analysis}, \strong{2}, 143-158.

Muller, K. E. and LaVange, L. M. and Ramey, S. L. and Ramey, C. T. (1992).
Power Calculations for General Linear Multivariate Models Including Repeated
Measures Applications. \emph{Journal of the American Statistical
Association}, \strong{87}, 1209-1226.
}
\seealso{
\code{\link[car]{Anova}}

\code{\link[effectsize]{eta_squared}} for a function that calculates this effect size measure for each response variable separately.
}
\author{
Michael Friendly
}
\concept{effect size}
\concept{strength of association}
\keyword{multivariate}
