% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-fun.R
\name{test_fun}
\alias{test_fun}
\title{Run test attached to function}
\usage{
test_fun(object, reporter = testthat::MinimalReporter)
}
\arguments{
\item{object}{to which the test is attached}

\item{reporter}{\link[testthat:Reporter]{testthat::Reporter} to use}
}
\value{
the test (function)
}
\description{
Execute test attached to a function with \link[testthat:Reporter]{testthat::Reporter}.
}
\examples{

f <- function(x) x^2

test(f) <- function() {
   context("f")

   test_that("correct result for complex number", {
     expect_equal(f(1i), -1 + 0i)
   })
}

test_fun(f)
}
