% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_network.R
\name{subset_network}
\alias{subset_network}
\alias{subset_network.data.frame}
\alias{subset_network.hy}
\title{Subset Network}
\usage{
subset_network(x, outlet, only_up = FALSE)

\method{subset_network}{data.frame}(x, outlet, only_up = FALSE)

\method{subset_network}{hy}(x, outlet, only_up = FALSE)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{outlet}{identifier of the outlet flowpath to subset upstream from.}

\item{only_up}{logical if \code{TRUE}, only upstream navigation is used and
any missed diversion connections are disconnected. If \code{FALSE} (default),
nested endorheic basins reachable through diversions are also included.}
}
\value{
data.frame subset of \code{x} containing flowpaths upstream of
the outlet.

Note: if "toid" is included in the input, it will be returned without modification.
This may result in one or more "toid" entries that contain ids that are not part
of the subset.
}
\description{
Subsets a network to features upstream of a given outlet.
For non-dendritic networks, the function identifies flowpaths connected
to the upstream basin via fromnode/tonode that are not reachable by
upstream navigation alone. This is useful for networks where an upstream
navigation returns a basin that contains a nested basin (closed or intersecting)
connected through diversions. If \code{only_up} is \code{FALSE}, those
nested basins are captured by navigating downstream from missed diversions
to find their outlets, then navigating upstream from those outlets.

Note: If a diversion leaves a basin entirely, the subset will include the
entire basin upstream of where the diversion terminates. this function
will return both closed basins and intersecting basins.
}
\details{
Required attributes: \code{id}, \code{fromnode}, \code{tonode}

Conditionally: \code{divergence} (if non-dendritic)
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

sub <- subset_network(x, 8893420)

nrow(sub)

}
