% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadDatsuFileFireAndForget.R
\name{uploadDatsuFileFireAndForget}
\alias{uploadDatsuFileFireAndForget}
\title{get list of records for a dataset}
\usage{
uploadDatsuFileFireAndForget(
  fileToUpload,
  dataSetVerID,
  emailAddress = NULL,
  sendEmail = TRUE,
  errorLimit = 30000,
  verbose = FALSE
)
}
\arguments{
\item{fileToUpload}{the filename of the file to upload}

\item{dataSetVerID}{The version of the dataset}

\item{emailAddress}{alternative email address of the user, if NULL, email address from ICES token
is used}

\item{sendEmail}{it is set to TRUE by default, this will specify if the user will to receive an
email when the session is finished}

\item{errorLimit}{does not need to be specified, it is 30000 by default}

\item{verbose}{get verbose output from the POST request, default FALSE}
}
\value{
The ID of the DATSU session
}
\description{
This API allows the user to screen a file using the API.
}
\examples{

\dontrun{
filename <- system.file("test_files/vms_test.csv", package = "icesDatsu")
id <- uploadDatsuFileFireAndForget(filename, 145)
getScreeningSessionDetails(id)
messages <- getScreeningSessionMessages(id)
head(messages)

uploadDatsuFileFireAndForget(filename, 145, sendEmail = FALSE)
}
}
