% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_LLR.R
\name{calibrate_LLR}
\alias{calibrate_LLR}
\title{Calibrate scores into Log-Likelihood Ratios}
\usage{
calibrate_LLR(calibration.dataset, dataset, latex = FALSE)
}
\arguments{
\item{calibration.dataset}{A data frame containing the calibration dataset, typically the output of an authorship analysis function like \code{\link[=impostors]{impostors()}}.}

\item{dataset}{A data frame containing the scores that have to be calibrated into LLRs using the calibration dataset. This is typically the result of applying a function like \code{\link[=impostors]{impostors()}} to the Q texts.}

\item{latex}{A logical value. If FALSE (default), then the hypothesis labels are printed as plain text (Hp/Hd). If TRUE the labels are written to be read in LaTeX ($H_p$/$H_d$).}
}
\value{
The function returns a data frame with the LLRs (base 10), as well as the verbal label according to Marquis et al (2016) and a verbal interpretation of the results.
}
\description{
This function is used to transform the scores returned by any of the authorship analysis functions into a Log-Likelihood Ratio (LLR).
}
\examples{
calib <- data.frame(score = c(0.5, 0.2, 0.8, 0.01, 0.6), target = c(TRUE, FALSE, TRUE, FALSE, TRUE))
q <- data.frame(score = c(0.6, 0.002))
calibrate_LLR(calib, q)

}
\references{
Marquis, Raymond, Alex Biedermann, Liv Cadola, Christophe Champod, Line Gueissaz, Geneviève Massonnet, Williams David Mazzella, Franco Taroni & Tacha Hicks. 2016. Discussion on how to implement a verbal scale in a forensic laboratory: Benefits, pitfalls and suggestions to avoid misunderstandings. Science & Justice 56(5). 364–370. https://doi.org/10.1016/j.scijus.2016.05.009.
}
