% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_int.R
\name{intEST}
\alias{intEST}
\title{Returns the estimates of for an unspecified interaction model}
\usage{
intEST(
  var2values,
  model,
  data,
  var1,
  var2,
  ci = TRUE,
  conf = 0.95,
  ci.method = "delta",
  ci.boot.method = "perc",
  R = 100,
  parallel = "multicore",
  ...
)
}
\arguments{
\item{var2values}{numeric vector of var2 points to estimate}

\item{model}{model of class cph, coxph, lrm, glm or Glm. If data is NULL, the function expects to find the data in model$x.}

\item{data}{data used in the model. If absent, we will attempt to recover the data from the model. Only used for bootstrap and glm class models}

\item{var1}{variable that increases by 1 unit from 0}

\item{var2}{variable to spline. var2values belong to var2}

\item{ci}{calculate 95\% CI?}

\item{conf}{confidence level. Default 0.95}

\item{ci.method}{confidence interval method. "delta" performs delta method. "bootstrap" performs bootstrapped CI (slower)}

\item{ci.boot.method}{one of the available bootstrap CI methods from \code{\link[boot]{boot.ci}}. Default percentile}

\item{R}{number of bootstrap samples if ci.method = "bootstrap". Default 100}

\item{parallel}{can take values "no", "multicore", "snow" if ci.method = "bootstrap". Default multicore}

\item{...}{other parameters for boot}
}
\value{
if ci = FALSE, a dataframe with initial values and OR/HR/linear estimates
, if ci = TRUE a dataframe with 5 columns, initial values, OR/HR/linear estimates, lower CI, upper CI and SE
}
\description{
This function is a dispatcher that generate OR, HR or linear estimates values for a simple or restricted cubic spline
interaction model from a logistic, Cox or linear regression
}
\examples{
library(rms)
library(mlbench)
data(PimaIndiansDiabetes)
# Set age on a 5-year scale
PimaIndiansDiabetes$age <- PimaIndiansDiabetes$age/5
# Recode diabetes as 0/1
PimaIndiansDiabetes$diabetes <- ifelse(PimaIndiansDiabetes$diabetes=="pos" , 1 , 0)
# Logistic model predicting diabetes over BMI, age and glucose
myformula <- diabetes ~ mass + age * rcs( glucose , 3 )
model <- lrm(myformula , data = PimaIndiansDiabetes )
intEST( var2values = 20:80
       , model = model , data = PimaIndiansDiabetes , var1 ="age", var2="glucose"
       , ci=TRUE , conf = 0.95 , ci.method = "delta")
# Linear model predicting BMI over diabetes, age and glucose
myformula2 <- mass ~ diabetes + age * rcs( glucose , 3 )
model2 <- glm(myformula2 , data = PimaIndiansDiabetes , family = "gaussian")
intEST( var2values = 20:80
       , model = model2 , data = PimaIndiansDiabetes , var1 ="age", var2="glucose"
       , ci=TRUE , conf = 0.95 , ci.method = "delta")
}
