% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_jmSurface}
\alias{simulate_jmSurface}
\title{Simulate Multi-State Joint Modeling Data}
\usage{
simulate_jmSurface(
  n_patients = 500,
  max_followup = 15,
  max_events = 3,
  seed = 42
)
}
\arguments{
\item{n_patients}{Integer number of patients. Default \code{500}.}

\item{max_followup}{Numeric maximum follow-up time in years. Default \code{15}.}

\item{max_events}{Integer maximum number of events per patient. Default \code{3}.}

\item{seed}{Integer random seed. Default \code{42}.}
}
\value{
A list with two data frames:
\item{long_data}{Longitudinal biomarker measurements with columns
\code{patient_id}, \code{visit_time_years}, \code{biomarker},
\code{value}, \code{unit}}
\item{surv_data}{Survival/transition data with columns
\code{patient_id}, \code{start_time}, \code{stop_time},
\code{status}, \code{event_type}, \code{state_from}, \code{state_to},
\code{transition}, \code{entry_disease}, \code{age_baseline},
\code{sex}, \code{ethnicity}, \code{smoking}, \code{bmi}}
}
\description{
Generates realistic simulated data for a multi-state chronic disease
cohort (CKD/CVD/Diabetes) with three longitudinal biomarkers (eGFR,
BNP, HbA1c) and bidirectional transitions. Includes demographic
covariates and realistic biomarker trajectories.
}
\examples{
sim <- simulate_jmSurface(n_patients = 200, seed = 123)
head(sim$long_data)
table(sim$surv_data$transition)

}
