% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ref_info.R
\name{get_ref_info}
\alias{get_ref_info}
\title{Obtain Reference Information for a Global Reference Group}
\usage{
get_ref_info(ref_path, .spl_context, .var = NULL)
}
\arguments{
\item{ref_path}{(\code{character})\cr reference group specification as an \code{rtables}
\code{colpath}, see details.}

\item{.spl_context}{(\code{data.frame})\cr see \link[rtables:spl_context]{rtables::spl_context}.}

\item{.var}{(\code{character})\cr the variable being analyzed, see \link[rtables:additional_fun_params]{rtables::additional_fun_params}.}
}
\value{
A list with \code{ref_group} and \code{in_ref_col}, which can be used as
\code{.ref_group} and \code{.in_ref_col} as if being directly passed to an analysis
function by \code{rtables}, see \link[rtables:additional_fun_params]{rtables::additional_fun_params}.
}
\description{
This helper function can be used in custom analysis functions, by passing
an extra argument \code{ref_path} which defines a global reference group by
the corresponding column split hierarchy levels.
}
\details{
The reference group is specified in \code{colpath} hierarchical fashion in \code{ref_path}:
the first column split variable is the first element, and the level to use is the
second element. It continues until the last column split variable with last
level to use.
Note that depending on \code{.var}, either a \code{data.frame} (if \code{.var} is \code{NULL}) or
a vector (otherwise) is returned. This allows usage for analysis functions with
\code{df} and \code{x} arguments, respectively.
}
\examples{
dm <- DM
dm$colspan_trt <- factor(
  ifelse(dm$ARM == "B: Placebo", " ", "Active Study Agent"),
  levels = c("Active Study Agent", " ")
)
colspan_trt_map <- create_colspan_map(
  dm,
  non_active_grp = "B: Placebo",
  non_active_grp_span_lbl = " ",
  active_grp_span_lbl = "Active Study Agent",
  colspan_var = "colspan_trt",
  trt_var = "ARM"
)

standard_afun <- function(x, .ref_group, .in_ref_col) {
  in_rows(
    "Difference of Averages" = non_ref_rcell(
      mean(x) - mean(.ref_group),
      is_ref = .in_ref_col,
      format = "xx.xx"
    )
  )
}

result_afun <- function(x, ref_path, .spl_context, .var) {
  ref <- get_ref_info(ref_path, .spl_context, .var)
  standard_afun(x, .ref_group = ref$ref_group, .in_ref_col = ref$in_ref_col)
}

ref_path <- c("colspan_trt", " ", "ARM", "B: Placebo")

lyt <- basic_table() |>
  split_cols_by(
    "colspan_trt",
    split_fun = trim_levels_to_map(map = colspan_trt_map)
  ) |>
  split_cols_by("ARM") |>
  analyze(
    "AGE",
    extra_args = list(ref_path = ref_path),
    afun = result_afun
  )

build_table(lyt, dm)
}
