% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohen_d_from_cohen_textbook.R
\name{cohen_d_from_cohen_textbook}
\alias{cohen_d_from_cohen_textbook}
\title{Cohen's d from Jacob Cohen's textbook (1988)}
\usage{
cohen_d_from_cohen_textbook(
  sample_1 = NULL,
  sample_2 = NULL,
  data = NULL,
  iv_name = NULL,
  dv_name = NULL
)
}
\arguments{
\item{sample_1}{a vector of values in the first of two samples}

\item{sample_2}{a vector of values in the second of two samples}

\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable}
}
\value{
the output will be a Cohen's d value (a numeric vector
of length one)
}
\description{
Calculates Cohen's d as described in Jacob Cohen's textbook (1988),
Statistical Power Analysis for the Behavioral Sciences, 2nd Edition
Cohen, J. (1988) \doi{10.4324/9780203771587}
}
\examples{
cohen_d_from_cohen_textbook(1:10, 3:12)
cohen_d_from_cohen_textbook(
  data = mtcars, iv_name = "vs", dv_name = "mpg"
)
}
