% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuse.R
\name{crack}
\alias{crack}
\alias{sieve}
\title{Parse R Markdown or R scripts}
\usage{
crack(input, text = NULL)

sieve(input, text = NULL)
}
\arguments{
\item{input}{A character vector to provide the input file path or text. If
not provided, the \code{text} argument must be provided instead. The \code{input}
vector will be treated as a file path if it is a single string, and points
to an existing file or has a filename extension. In other cases, the vector
will be treated as the \code{text} argument input. To avoid ambiguity, if a
string should be treated as \code{text} input when it happens to be an existing
file path or has an extension, wrap it in \code{\link[=I]{I()}}, or simply use the \code{text}
argument instead.}

\item{text}{A character vector as the text input. By default, it is read from
the \code{input} file if provided.}
}
\value{
A list of code chunks and text blocks:
\itemize{
\item Code chunks are of the form \code{list(source, type = "code_chunk", options,   comments, ...)}: \code{source} is a character vector of the source code of a
code chunk, \code{options} is a list of chunk options, and \code{comments} is a
vector of pipe comments.
\item Text blocks are of the form \code{list(source, type = "text_block", ...)}. If
the text block does not contain any inline code, \code{source} will be a
character string (lines of text concatenated by line breaks), otherwise it
will be a list with members that are either character strings (normal text
fragments) or lists of the form \code{list(source, options, ...)} (\code{source} is
the inline code, and \code{options} contains its options specified inside \code{  `{lang, ...}`}).
}

Both code chunks and text blocks have a list member named \code{lines} that
stores their starting and ending line numbers in the input.
}
\description{
Parse input into code chunks, inline code expressions, and text fragments:
\code{\link[=crack]{crack()}} is for parsing R Markdown, and \code{\link[=sieve]{sieve()}} is for R scripts.
}
\details{
For R Markdown, a code chunk must start with a fence of the form \verb{```\{lang\}}, where \code{lang} is the language name, e.g., \code{r} or \code{python}. The
body of a code chunk can start with chunk options written in "pipe comments",
e.g., \verb{#| eval = TRUE, echo = FALSE} (the CSV syntax) or \verb{#| eval: true} (the
YAML syntax). An inline code fragment is of the form \code{`{lang} source`}
embedded in Markdown text.

For R scripts, text blocks are extracted by removing the leading
\verb{#'} tokens. All other lines are treated as R code, which can optionally be
separated into chunks by consecutive lines of \verb{#|} comments (chunk options
are written in these comments). If no \verb{#'} or \verb{#|} tokens are found in the
script, the script will be divided into chunks that contain smallest
possible complete R expressions.
}
\note{
For simplicity, \code{\link[=sieve]{sieve()}} does not support inline code expressions.
Text after \verb{#'} is treated as pure Markdown.

It is a pure coincidence that the function names \code{crack()} and \code{sieve()}
weakly resemble Carson Sievert's name, but I will consider adding a class
name \code{sievert} to the returned value of \code{sieve()} if Carson becomes the
president of the United States someday, which may make the value
radioactive and introduce a new programming paradigm named \emph{Radioactive
Programming} (in case \emph{Reactive Programming} is no longer fun or cool).
}
\examples{
library(litedown)
# parse R Markdown
res = crack(c("```{r}\n1+1\n```", "Hello, `pi` = `{r} pi` and `e` = `{r} exp(1)`!"))
str(res)
# evaluate inline code and combine results with text fragments
txt = lapply(res[[2]]$source, function(x) {
    if (is.character(x))
        x else eval(parse(text = x$source))
})
paste(unlist(txt), collapse = "")

# parse R code
res = sieve(c("#' This is _doc_.", "", "#| eval=TRUE", "# this is code", "1 + 1"))
str(res)
}
