% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_client.R
\name{llm_provider}
\alias{llm_provider}
\title{Create OpenAI-compatible LLM provider with enhanced error handling}
\usage{
llm_provider(
  base_url = "https://api.openai.com/v1/chat/completions",
  api_key = NULL,
  model = "gpt-4o-mini",
  temperature = 0.2,
  max_tokens = 5000,
  timeout = 100,
  stream = FALSE,
  verbose = TRUE,
  skip_test = FALSE,
  test_mode = c("full", "http_only", "skip"),
  ...
)
}
\arguments{
\item{base_url}{The base URL for the OpenAI-compatible API}

\item{api_key}{The API key for authentication. If NULL, will use LLM_API_KEY env var}

\item{model}{The model name to use}

\item{temperature}{The temperature parameter for response randomness}

\item{max_tokens}{Maximum number of tokens in response (will auto-adjust if exceeds model limit)}

\item{timeout}{Request timeout in seconds}

\item{stream}{Whether to use streaming responses}

\item{verbose}{Whether to show verbose output}

\item{skip_test}{Whether to skip the availability test (useful for problematic providers)}

\item{test_mode}{The testing mode: "full", "http_only", "skip"}

\item{...}{Additional parameters to pass to the model}
}
\value{
A configured LLM provider object
}
\description{
This function creates an OpenAI-compatible LLM provider with comprehensive
error handling and testing capabilities. It automatically handles max_tokens
limits by falling back to the model's maximum when exceeded.
}
\author{
Zaoqu Liu; Email: liuzaoqu@163.com
}
