% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account.R
\name{account_login}
\alias{account_login}
\title{Authenticate with LOBSTER account}
\usage{
account_login(login, pwd)
}
\arguments{
\item{login}{character(1) Email address associated with the LOBSTER account.}

\item{pwd}{character(1) Account password.}
}
\value{
A named list with components:
\describe{
\item{valid}{logical(1) — \code{TRUE} when authentication succeeded.}
\item{session}{rvest session object used for further navigation.}
\item{submission}{rvest response returned after the sign-in form was submitted.}
}
}
\description{
Logs into your LOBSTER account and creates a session object for subsequent
data requests. This function handles the authentication process with
lobsterdata.com and validates the login was successful.
}
\details{
The function submits the sign-in form using an AJAX header
(\code{x-requested-with: XMLHttpRequest}) and confirms success by checking the
redirect URL. Network connectivity and valid credentials are required.

Store credentials in your \code{.Renviron} file
(\code{usethis::edit_r_environ()}) to avoid hardcoding them in scripts:

\if{html}{\out{<div class="sourceCode">}}\preformatted{LOBSTER_USER=you@example.com
LOBSTER_PWD=your-password
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
acct <- account_login(
  login = Sys.getenv("LOBSTER_USER"),
  pwd   = Sys.getenv("LOBSTER_PWD")
)

if (acct$valid) {
  # Retrieve available datasets in the archive
  archive <- account_archive(acct)

  # Build and submit a new data request
  req <- request_query("AAPL", "2023-01-03", "2023-01-05", level = 1)
  request_submit(acct, req)
}
}

}
\seealso{
\code{\link[=account_archive]{account_archive()}}, \code{\link[=request_submit]{request_submit()}}
}
