% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_palette.R
\name{adjust_ltc}
\alias{adjust_ltc}
\title{Adjust Lightness of Palette Colors}
\usage{
adjust_ltc(palette_name, amount = 0, which = NULL)
}
\arguments{
\item{palette_name}{Character or unquoted name. Name of the ltc palette to adjust.}

\item{amount}{Numeric. Amount to adjust lightness (-100 to 100).
Negative values darken, positive values lighten. Default is 0 (no change).}

\item{which}{Integer vector. Which colors to adjust (e.g., c(1, 3) for 1st and 3rd).
If NULL (default), adjusts all colors.}
}
\value{
A vector of adjusted hex color codes with class "ltc"
}
\description{
Darken or lighten an entire palette or specific colors within it.
Uses the colorspace package for perceptually uniform adjustments.
}
\examples{
\donttest{
# Darken entire palette
adjust_ltc(alger, amount = -20)

# Lighten entire palette
adjust_ltc("maya", amount = 30)

# Darken only specific colors
adjust_ltc(remains, amount = -25, which = c(2, 4))
}
}
