% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_annotation.R
\name{interactive_consensus_annotation}
\alias{interactive_consensus_annotation}
\title{Interactive consensus building for cell type annotation}
\usage{
interactive_consensus_annotation(
  input,
  tissue_name,
  models = c("claude-opus-4-6-20260205", "gpt-5.2", "gemini-3-pro", "deepseek-r1",
    "grok-4.1"),
  api_keys,
  top_gene_count = 10,
  controversy_threshold = 0.7,
  entropy_threshold = 1,
  max_discussion_rounds = 3,
  consensus_check_model = NULL,
  log_dir = "logs",
  cache_dir = NULL,
  use_cache = TRUE,
  base_urls = NULL,
  clusters_to_analyze = NULL,
  force_rerun = FALSE
)
}
\arguments{
\item{input}{Either a data frame from Seurat's FindAllMarkers() function containing
differential gene expression results (must have columns: 'cluster', 'gene',
and 'avg_log2FC'), or a list where each element is either a character vector
of genes or a list containing a \code{genes} field.}

\item{tissue_name}{Character string specifying the tissue type for context-aware
cell type annotation (e.g., 'human PBMC', 'mouse brain'). Required.}

\item{models}{Character vector of model names to use for consensus annotation.
Minimum 2 models required. Supports models from OpenAI, Anthropic, DeepSeek,
Google, Alibaba, Stepfun, Zhipu, MiniMax, X.AI, and OpenRouter.}

\item{api_keys}{Named, non-empty list of API keys. Can use provider names as keys
(e.g., "openai", "anthropic") or model names as keys (e.g., "gpt-5").}

\item{top_gene_count}{Integer specifying the number of top marker genes to use
for annotation per cluster (default: 10).}

\item{controversy_threshold}{Numeric value between 0 and 1 for consensus proportion
threshold. Clusters below this threshold are considered controversial (default: 0.7).}

\item{entropy_threshold}{Numeric value for entropy threshold. Higher entropy
indicates more disagreement among models (default: 1.0).}

\item{max_discussion_rounds}{Integer specifying maximum number of discussion rounds
for controversial clusters (default: 3).}

\item{consensus_check_model}{Character string specifying which model to use for
consensus checking. If NULL, uses the first model from the models list.}

\item{log_dir}{Character scalar specifying directory for log files (default: "logs").
This function reinitializes the session logger with this directory at the start
of each call.}

\item{cache_dir}{Character string or NULL. Cache directory for storing results.
NULL uses system cache, "local" uses current directory, "temp" uses temporary
directory, or specify custom path.}

\item{use_cache}{Logical indicating whether to use caching (default: TRUE).}

\item{base_urls}{Named list or character string specifying custom API base URLs.
Useful for proxies or alternative endpoints. If NULL, uses official endpoints.}

\item{clusters_to_analyze}{Character or numeric vector specifying which clusters
to analyze. If NULL (default), all clusters are analyzed.}

\item{force_rerun}{Logical indicating whether to force rerun of all specified
clusters, ignoring cache. Only affects controversial cluster discussions
(default: FALSE).}
}
\value{
A list containing:
\itemize{
\item \code{initial_results}: Initial voting results, consensus checks, and controversial cluster IDs
\item \code{final_annotations}: Final annotations keyed by cluster ID
\item \code{controversial_clusters}: Clusters identified as controversial
\item \code{discussion_logs}: Detailed discussion logs for controversial clusters
\item \code{session_id}: Logger session identifier
\item \code{voting_results}: Backward-compatible alias of \code{initial_results}
\item \code{discussion_results}: Backward-compatible alias of \code{discussion_logs}
\item \code{final_consensus}: Backward-compatible alias of \code{final_annotations}
}
}
\description{
This function implements an interactive voting and discussion mechanism where multiple LLMs
collaborate to reach a consensus on cell type annotations, particularly focusing on
clusters with low agreement. The process includes:
\enumerate{
\item Initial voting by all LLMs
\item Identification of controversial clusters
\item Detailed discussion for controversial clusters
\item Final summary by a designated LLM (default: Claude)
}
}
