% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fict.R
\docType{data}
\name{fict_marvel}
\alias{fict_marvel}
\title{Multiplex two-mode affiliation and one-mode signed relationship network of
Marvel comic book characters (Yuksel 2017)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> 
#> -- # Marvel universe -----------------------------------------------------------
#> # A labelled, complex, multiplex, signed, two-mode network of 53 characters and
#> 141 teams and 683 affiliation, and 558 relationship ties
#> 
#> -- Nodes
#> # A tibble: 194 x 11
#>   type  name          Gender Appearances Attractive  Rich Intellect Omnilingual
#>   <lgl> <chr>         <chr>        <int>      <int> <int>     <int>       <int>
#> 1 FALSE Abomination   Male           427          0     0         1           1
#> 2 FALSE Ant-Man       Male           589          1     0         1           0
#> 3 FALSE Apocalypse    Male          1207          0     0         1           1
#> 4 FALSE Beast         Male          7609          1     0         1           0
#> 5 FALSE Black Panther Male          2189          1     1         1           0
#> 6 FALSE Black Widow   Female        2907          1     0         1           0
#> # i 188 more rows
#> # i 3 more variables: PowerOrigin <chr>, UnarmedCombat <int>, ArmedCombat <int>
#> 
#> -- Ties
#> # A tibble: 1,241 x 4
#>    from    to type          sign
#>   <int> <int> <chr>        <dbl>
#> 1     1     1 relationship    -1
#> 2     1     4 relationship    -1
#> 3     1    11 relationship    -1
#> 4     1    12 relationship    -1
#> 5     1    23 relationship    -1
#> 6     1    24 relationship    -1
#> # i 1,235 more rows
#> 
}\if{html}{\out{</div>}}
}
\source{
Umut Yuksel, 31 March 2017
}
\usage{
data(fict_marvel)
}
\description{
This multiplex network contains two types of ties related to the
Marvel \emph{comic book} universe.
The "affiliation" ties offer a two-mode affiliation network of 53
Marvel comic book characters and their affiliations to 141 teams.
The "relationship" ties offer a one-mode signed network
of friendships and enmities between the 53 Marvel comic book characters.
Friendships are indicated by a positive sign in the tie \code{sign} attribute,
whereas enmities are indicated by a negative sign in this edge attribute.
}
\details{
Additional nodal variables have been coded and included by Dr Umut Yuksel:
\itemize{
\item \strong{Gender}: binary character, 43 "Male" and 10 "Female"
\item \strong{PowerOrigin}: binary character, 2 "Alien", 1 "Cyborg", 5 "God/Eternal",
22 "Human", 1 "Infection", 16 "Mutant", 5 "Radiation", 1 "Robot"
\item \strong{Appearances}: integer, in how many comic book issues they appeared in
\item \strong{Attractive}: binary integer, 41 1 (yes) and 12 0 (no)
\item \strong{Rich}: binary integer, 11 1 (yes) and 42 0 (no)
\item \strong{Intellect}: binary integer, 39 1 (yes) and 14 0 (no)
\item \strong{Omnilingual}: binary integer, 8 1 (yes) and 45 0 (no)
\item \strong{UnarmedCombat}: binary integer, 51 1 (yes) and 2 0 (no)
\item \strong{ArmedCombat}: binary integer, 25 1 (yes) and 28 0 (no)
}

See also https://graphics.straitstimes.com/STI/STIMEDIA/Interactives/2018/04/marvel-cinematic-universe-whos-who-interactive/index.html.
}
\keyword{datasets}
