% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-can-box.R
\name{esp_get_can_box}
\alias{esp_get_can_box}
\alias{esp_get_can_provinces}
\title{Canary Islands inset box and outline}
\source{
Coordinates of \code{esp_get_can_provinces()} derived from CartoBase ANE
(\code{se89_mult_admin_provcan_l.shp}).
}
\usage{
esp_get_can_box(
  style = c("right", "left", "box", "poly"),
  moveCAN = TRUE,
  epsg = 4258
)

esp_get_can_provinces(moveCAN = TRUE, epsg = "4258")
}
\arguments{
\item{style}{character string. One of \code{"right"}, \code{"left"}, \code{"box"} or
\code{"poly"}. Default is \code{"right"}, see \strong{Details}.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands} in \code{\link[=esp_move_can]{esp_move_can()}}.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4258"}: \href{https://epsg.io/4258}{ETRS89}
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}
}
\value{
An \code{\link[sf:sf]{sf}} object: a \code{POLYGON} (when \code{style = "poly"}) or a
\code{LINESTRING} (other styles).
}
\description{
Create an \code{sf} \code{POLYGON} or \code{LINESTRING} that can be used to mark or
frame the Canary Islands when they are displayed as an inset on maps of
Spain. This object is useful together with \code{\link[=esp_move_can]{esp_move_can()}} and the
\code{moveCAN} arguments available in other \code{mapSpain} getters.

\code{esp_get_can_provinces()} returns a small \code{LINESTRING} used to mark the
separator between the two provinces of the Canary Islands. This helper is
intended for cartographic use when composing inset maps of Spain.
}
\details{
The \code{style} parameter controls the geometry returned:
\itemize{
\item \code{"box"}: a rectangular boundary returned as a \code{LINESTRING}.
\item \code{"poly"}: a slightly expanded rectangle returned as a filled \code{POLYGON}.
\item \code{"left"} / \code{"right"}: decorative \code{LINESTRING} variants that follow
the western or eastern side of the islands respectively.
}
}
\examples{
provs <- esp_get_prov()
box <- esp_get_can_box()
line <- esp_get_can_provinces()

library(ggplot2)
ggplot(provs) +
  geom_sf() +
  geom_sf(data = box, linewidth = 0.15) +
  geom_sf(data = line, linewidth = 0.15) +
  theme_linedraw()

\donttest{
# Displacing the Canary Islands by a custom offset
displace <- c(15, 0)
provs_disp <- esp_get_prov(moveCAN = displace)
box_disp <- esp_get_can_box(style = "left", moveCAN = displace)
line_disp <- esp_get_can_provinces(moveCAN = displace)
ggplot(provs_disp) +
  geom_sf() +
  geom_sf(data = box_disp, linewidth = 0.15) +
  geom_sf(data = line_disp, linewidth = 0.15) +
  theme_linedraw()

# Example using the polygon style together with other layers
library(giscoR)
res <- "20"
countries <- gisco_get_countries(
  res = res, epsg = "4326",
  country = c("France", "Portugal", "Andorra", "Morocco", "Argelia")
)
can_box <- esp_get_can_box(
  style = "poly", epsg = "4326",
  moveCAN = c(12.5, 0)
)
ccaa <- esp_get_ccaa(res = res, epsg = "4326", moveCAN = c(12.5, 0))
ggplot(countries) +
  geom_sf(fill = "#DFDFDF") +
  geom_sf(data = can_box, fill = "#C7E7FB", linewidth = 1) +
  geom_sf(data = ccaa, fill = "#FDFBEA") +
  coord_sf(xlim = c(-10, 4.3), ylim = c(34.6, 44)) +
  theme(
    panel.background = element_rect(fill = "#C7E7FB"),
    panel.grid = element_blank()
  )
}
}
\seealso{
Other helpers for the Canary Islands:
\code{\link{esp_move_can}()}
}
\concept{can_helpers}
