% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{paste_mapping}
\alias{paste_mapping}
\title{A mapping that adds a prefix and/or suffix}
\usage{
paste_mapping(prefix = NULL, suffix = NULL)
}
\arguments{
\item{prefix, suffix}{Character strings.}
}
\value{
A \code{mapping} function.
}
\description{
A mapping that adds a prefix and/or suffix
}
\examples{

# The objective is to turn a numeric vector into a factor such that
# the levels preserve the numeric order but contain the suffix "mg"
# (i.e., so that 2 becomes "2 mg" for instance)
x <- c(1, 2, 1, 10, 3, 2, 2, 1)

# The following does not produce the levels in the desired numeric order
# (because alphabetical ordering places "10" before "2")
factor(paste(x, "mg"))

# The following works, but takes 2 lines of code and requires a variable
# assignment
y <- factor(x)
levels(y) <- paste(levels(y), "mg")
y

# This does the same thing with one line of code and no assignment
paste_mapping(, " mg")(x)

# -----

# In this example, you start with a factor, and want to preserve its ordering
x <- factor(c("Treatment", "Placebo"), levels=c("Treatment", "Placebo"))

# Again, this won't work as desired
factor(paste("Randomized to", x, "Group"))

# But this will
paste_mapping("Randomized to ", " Group")(x)
}
