% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mappoly-color-palettes}
\alias{mappoly-color-palettes}
\alias{mp_pallet1}
\alias{mp_pallet2}
\alias{mp_pallet3}
\title{MAPpoly Color Palettes}
\usage{
mp_pallet1(n)
}
\description{
Provides a set of color palettes designed for use with MAPpoly, 
a package for genetic mapping in polyploids. These palettes are 
intended to enhance the visual representation of genetic data.
}
\details{
The available palettes are:
\describe{
  \item{\code{mp_pallet1}}{A palette with warm colors ranging from yellow to dark red and brown.}
  \item{\code{mp_pallet2}}{A palette with cool colors, including purples, blues, and green.}
  \item{\code{mp_pallet3}}{A comprehensive palette that combines colors from both \code{mp_pallet1} and \code{mp_pallet2}, offering a broad range of colors.}
}

Each palette function returns a function that can generate color vectors of variable length, suitable for mapping or plotting functions in R.
}
\examples{
# Generate a palette of 5 colors from mp_pallet1
pal1 <- mp_pallet1(5)
plot(1:5, pch=19, col=pal1)

# Generate a palette of 10 colors from mp_pallet2
pal2 <- mp_pallet2(10)
plot(1:10, pch=19, col=pal2)

# Generate a palette of 15 colors from mp_pallet3
pal3 <- mp_pallet3(15)
plot(1:15, pch=19, col=pal3)
}
\keyword{internal}
