% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F19.R
\name{F19}
\alias{F19}
\title{Hartmann 3D Function (F19)}
\usage{
F19(x)
}
\arguments{
\item{x}{Numeric vector of length 3 (3-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function with 4 local minima in 3 dimensions.
Fixed dimension of 3.
}
\details{
\strong{Formula:}
\deqn{f(x) = -\sum_{i=1}^{4} c_i \exp\left(-\sum_{j=1}^{3} a_{ij}(x_j - p_{ij})^2\right)}

where \eqn{a_{ij}}, \eqn{c_i}, and \eqn{p_{ij}} are predefined constants.

\strong{Global minimum:} \eqn{f(0.114614, 0.555649, 0.852547) \approx -3.86278}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 3
  \item Number of local minima: 4
  \item Default bounds: \eqn{[0, 1]^3}
}

The Hartmann functions are a family of multimodal test functions commonly
used in optimization benchmarks.
}
\examples{
F19(c(0.114614, 0.555649, 0.852547))  # Returns approximately -3.86278
F19(c(0.5, 0.5, 0.5))  # Returns a value > -3.86

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters,
\code{\link{F20}} for the 6D version.
}
