% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_shapes.R
\name{vertical_s}
\alias{vertical_s}
\alias{vertical_s_inv}
\alias{horizontal_s}
\alias{horizontal_s_inv}
\alias{s_vertical_s}
\alias{s_vertical_s_inv}
\alias{s_horizontal_s}
\alias{s_horizontal_s_inv}
\title{Coordinates of S-shaped figures}
\usage{
vertical_s(lty = 1, lwd = 3)

vertical_s_inv(lty = 1, lwd = 3)

horizontal_s(lty = 1, lwd = 3)

horizontal_s_inv(lty = 1, lwd = 3)

s_vertical_s(lty = 1, lwd = 3)

s_vertical_s_inv(lty = 1, lwd = 3)

s_horizontal_s(lty = 1, lwd = 3)

s_horizontal_s_inv(lty = 1, lwd = 3)
}
\arguments{
\item{lty}{integer, define the line type of the figure, default is 1 (solid line).}

\item{lwd}{integer, define the line width of the figure. Default is 3.}
}
\value{
Return the coordinates for drawing a vertical S-shaped figure

Return the coordinates for drawing an inverted vertical S-shaped figure

Return the coordinates for drawing an horizontal S-shaped figure

Return the coordinates for drawing an horizontal S-shaped figure

Return the coordinates for drawing a vertical S-shaped figure

Return the coordinates for drawing a single vertical S-shaped figure

Return the coordinates for drawing a single horizontal S-shaped figure

Return the coordinates for drawing a single inverted horizontal S-shaped figure
}
\description{
Define the coordinates for drawing S-shaped figures
}
\details{
Define the coordinates of a vertical S-shaped figure
}
\section{Functions}{
\itemize{
\item \code{vertical_s_inv()}: Coordinates of an inverted vertical S-shaped figure

Define the coordinates of an inverted vertical S-shaped figure

\item \code{horizontal_s()}: Coordinates of an horizontal S-shaped figure

Define the coordinates of an horizontal S-shaped figure

\item \code{horizontal_s_inv()}: Coordinates of an inverted horizontal S-shaped figure

Define the coordinates of an inverted horizontal S-shaped figure

\item \code{s_vertical_s()}: Coordinates of a single vertical S-shaped figure

Define the coordinates for drawing a single vertical S-shaped figure composed of two arches, which is forced to be a single figure (to be used in shape())

\item \code{s_vertical_s_inv()}: Coordinates of a single inverted vertical S-shaped figure

Define the coordinates for drawing a single inverted vertical S-shaped figure composed of two arches, which is forced to be a single figure (to be used in shape())

\item \code{s_horizontal_s()}: Coordinates of a single horizontal S-shaped figure

Define the coordinates for drawing a single horizontal S-shaped figure  composed of two arches, which is forced to be a single figure (to be used in shape())

\item \code{s_horizontal_s_inv()}: Coordinates of a single inverted horizontal S-shaped figure

Define the coordinates for drawing a single inverted horizontal S-shaped figure  composed of two arches, which is forced to be a single figure (to be used in shape())

}}
\examples{
# default coordinates of the vertical S-shaped figure
vertical_s()
# change the line type
vertical_s(lty = 2)
# default coordinates of the inverted vertical S-shaped figure
vertical_s_inv()
# change the line type
vertical_s_inv(lty = 2)
# default coordinates of the horizontal S
horizontal_s()
# change the line type
horizontal_s(lty = 2)
# default coordinates of the horizontal S-shaped figure
horizontal_s_inv()
# change the line type
horizontal_s_inv(lty = 2)
# default coordinates of the vertical S-shaped figure
s_vertical_s()
# change the line type
s_vertical_s(lty = 2)
# default coordinates of the single inverted vertical S-shaped figure
s_vertical_s_inv()
# change the line type
s_vertical_s_inv(lty = 2)
# default coordinates of the single horizontal S-shaped figure
s_horizontal_s()
# change the line type
s_horizontal_s(lty = 2)
# default coordinates of the single inverted horizontal S-shaped figure
s_horizontal_s_inv()
# change the line type
s_horizontal_s_inv(lty = 2)
}
