% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_RJC.R
\name{RJC}
\alias{RJC}
\title{Rotnitzky--Jewell Information Criterion}
\source{
Wang, M. (2014). Generalized estimating equations in longitudinal data
analysis: A review and recent developments. \emph{Advances in Statistics},
1(1), 1--13.
}
\usage{
RJC(object, id, verbose = TRUE)
}
\arguments{
\item{object}{An object of class \code{mcglm} representing a fitted
marginal model.}

\item{id}{An integer or factor vector identifying the clusters. Its
length and ordering must match the number and ordering of the
observations used to fit the model.}

\item{verbose}{Logical. If \code{TRUE}, the value of the RJC is printed
to the console.}
}
\value{
An invisible list with a single component:
\describe{
  \item{RJC}{A numeric scalar giving the value of the
  Rotnitzky--Jewell information criterion.}
}
}
\description{
Computes the Rotnitzky--Jewell information criterion (RJC) for objects of
class \code{mcglm}. This criterion is based on quasi-likelihood theory
and is intended for model assessment in marginal models.
}
\details{
The RJC is defined using the sensitivity and variability structures of
the estimating equations and measures the discrepancy between them.
The implementation assumes that the data are correctly ordered such
that observations belonging to the same cluster are stored in
contiguous rows.

\strong{Warning:} This function is restricted to models with a single
response variable.
}
\seealso{
\code{gof}, \code{plogLik}, \code{pAIC}, \code{pKLIC},
  \code{ESS}, \code{GOSHO}
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
