% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hypcube_smc}
\alias{hypcube_smc}
\title{Simple Monte Carlo Sampling}
\usage{
hypcube_smc(n, d, lbound = NA_real_, ubound = NA_real_)
}
\arguments{
\item{n}{Integer. The number of samples points of the hypercube.}

\item{d}{Integer. The the dimension of the hypercube.}

\item{lbound}{Numeric vector of length \code{d} specifying the
lower bounds for each dimension of the d-dimensional hypercube.}

\item{ubound}{Numeric vector of length \code{d} specifying the
ubound bounds for each dimension of the d-dimensional hypercube.}
}
\value{
A \code{n x d} matrix containing the SMC design. Each
element is scaled to the range defined by \code{lbound} and
\code{ubound}.
}
\description{
This function generates a Simple Monte Carlo (SMC) random design
matrix over the hypercube.
}
\examples{
x = hypcube_smc(100, 2)
plot(x, xlim = c(0,1), ylim = c(0,1))
rug(x[,1]); rug(x[,2], side = 2)
x = hypcube_smc(100, 2, lbound = c(-5,1), ubound = c(10,3))
plot(x, xlim = c(-5,10), ylim = c(1,3))
rug(x[,1]); rug(x[,2], side = 2)

}
