% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totals.R
\name{agg_totals}
\alias{agg_totals}
\title{Aggregate mcnode Values Across Groups}
\usage{
agg_totals(
  mcmodule,
  mc_name,
  agg_keys = NULL,
  agg_suffix = NULL,
  prefix = NULL,
  name = NULL,
  summary = TRUE,
  keep_variates = FALSE,
  agg_func = NULL
)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing node list and data.}

\item{mc_name}{(character). Name of node to aggregate.}

\item{agg_keys}{(character vector, optional). Column names for grouping.
If NULL, defaults to "scenario_id". Default: NULL.}

\item{agg_suffix}{(character, optional). Suffix for aggregated node name.
Default: "agg".}

\item{prefix}{(character, optional). Prefix for output node name. Default: NULL.}

\item{name}{(character, optional). Custom name for output node. Default: NULL.}

\item{summary}{(logical). If TRUE, include summary statistics. Default: TRUE.}

\item{keep_variates}{(logical). If TRUE, preserve individual variate values.
Default: FALSE.}

\item{agg_func}{(character, optional). Aggregation method: "prob" (combined
probability), "sum", "avg", or NULL (automatic). Default: NULL.}
}
\value{
mcmodule with new aggregated node added
}
\description{
Aggregates node values across grouping variables using various methods
(combined probability, sum, mean, or automatic selection). Returns an
updated mcmodule with new aggregated node.
}
\examples{
imports_mcmodule <- agg_totals(
  imports_mcmodule, "no_detect_a",
  agg_keys = c("scenario_id", "pathogen")
)
print(imports_mcmodule$node_list$no_detect_a_agg$summary)
}
