% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_module.R
\name{eval_module}
\alias{eval_module}
\title{Evaluate Monte Carlo Model Expressions}
\usage{
eval_module(
  exp,
  data,
  param_names = NULL,
  prev_mcmodule = NULL,
  summary = FALSE,
  mctable = set_mctable(),
  data_keys = set_data_keys(),
  match_keys = NULL,
  keys = NULL,
  overwrite_keys = NULL,
  use_baseline = NULL,
  use_variation = NULL
)
}
\arguments{
\item{exp}{(language or list). Model expression or list of expressions to evaluate.}

\item{data}{(data frame). Input data; number of rows determines nvariates for
\code{mcstoc()}/\code{mcdata()} in expressions. Default: required.}

\item{param_names}{(named character vector, optional). Names to rename parameters.
Default: NULL.}

\item{prev_mcmodule}{(mcmodule or list, optional). Previous module(s) for
dependent calculations. Default: NULL.}

\item{summary}{(logical). If TRUE, calculate summary statistics for output nodes.
Default: FALSE.}

\item{mctable}{(data frame). Reference table for mcnodes with \code{mcnode} and
\code{mc_func} columns. If NULL or not provided, nodes matching \code{data} column names
are automatically created. Default: empty mctable().}

\item{data_keys}{(list). Data structure and keys for input data. Default:
\code{set_data_keys()}.}

\item{match_keys}{(character vector, optional). Keys to match \code{prev_mcmodule}
mcnodes with current data. Default: NULL.}

\item{keys}{(character vector, optional). Explicit keys for input data. Default: NULL.}

\item{overwrite_keys}{(logical or NULL). If NULL (default), becomes TRUE when
\code{data_keys} is NULL or empty; otherwise FALSE.}

\item{use_baseline}{(character vector, optional). mcnode names to override with
\code{sensi_baseline} values from \code{mctable}. Default: NULL.}

\item{use_variation}{(character vector, optional). mcnode names to apply
\code{sensi_variation} expression from \code{mctable} before node creation. Default: NULL.}
}
\value{
An mcmodule object (list) with elements:
\itemize{
\item data: List containing input data frames.
\item exp: List of evaluated expressions.
\item node_list: Named list of mcnode objects with metadata.
}
}
\description{
Evaluates a model expression or list of expressions to produce an mcmodule
object containing simulation results and metadata. Expression may use
\code{mcstoc()} and \code{mcdata()} to create nodes inline; nvariates is automatically
inferred from the data.
}
\details{
\itemize{
\item mcstoc() and mcdata() may be used directly inside model expressions.
When these are used you should NOT explicitly supply nvariates, nvariates
will be inferred automatically as the number of rows in the input \code{data}.
Other arguments are preserved, for example specify \code{type = "0"} when
providing data without variability/uncertainty (see ?mcdata and ?mcstoc).
\item By design, mcmodule supports type = "V" (the default, with variability) and
type = "0" (no variability) nodes. Expressions that specify other node
types ("U" or "VU") are not fully supported and downstream compatibility is not
guaranteed.
\item An explicit \code{mctable} is optional but highly recommended. If no mctable is
provided, any model nodes that match column names in \code{data} will be built
from the data. If a \code{mctable} is provided and a node is not found there but
exists as a data column, a warning will be issued and the node will be created
from the data column.
\item Within expressions reference input mcnodes by their bare names (e.g.
column1). Do not use \code{data$column1} or \code{data["column1"]}.
}
}
\examples{
# Basic usage with single expression
# Build a quoted expression using mcnodes defined in mctable or built with
# mcstoc()/mcdata within the expression (do NOT set nvariates, it is
# inferred from nrow(data) when evaluated by eval_module()).
expr_example <- quote({
  # Within-herd prevalence (assigned from a pre-built mcnode w_prev)
  inf_a <- w_prev

  # Estimate of clinic sensitivity
  clinic_sensi <- mcstoc(runif, min = 0.6, max = 0.8)

  # Probability an infected animal is tested in origin and not detected
  false_neg_a <- inf_a * test_origin * (1 - test_sensi) * (1 - clinic_sensi)

  # Probability an infected animal is not tested and not detected
  no_test_a <- inf_a * (1 - test_origin) * (1 - clinic_sensi)

  # no_detect_a: total probability an infected animal is not detected
  no_detect_a <- false_neg_a + no_test_a
})

# Evaluate
eval_module(
  exp = expr_example,
  data = imports_data,
  mctable = imports_mctable,
  data_keys = imports_data_keys
)
}
