% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_filter.R
\name{mc_filter}
\alias{mc_filter}
\title{Filter mcnode Variates by Condition}
\usage{
mc_filter(
  mcmodule = NULL,
  mc_name = NULL,
  ...,
  data = NULL,
  mcnode = NULL,
  name = NULL,
  prefix = NULL,
  filter_suffix = "filtered",
  summary = TRUE
)
}
\arguments{
\item{mcmodule}{(mcmodule object, optional). Module containing the node.
Default: NULL.}

\item{mc_name}{(character, optional). Name of the mcnode in the module.}

\item{...}{(expression). Logical conditions to filter by; evaluated in context
of the data associated with the mcnode.}

\item{data}{(data frame, optional). Input data frame. Default: NULL.}

\item{mcnode}{(mcnode object, optional). mcnode to filter directly. Default: NULL.}

\item{name}{(character, optional). Name for the new filtered node when adding to
mcmodule. If NULL, auto-generated from \code{mc_name} and \code{filter_suffix}.
Default: NULL.}

\item{prefix}{(character, optional). Prefix for the auto-generated node name.
Default: NULL.}

\item{filter_suffix}{(character). Suffix appended to auto-generated name.
Default: "filtered".}

\item{summary}{(logical). If TRUE, compute summary statistics for the new node.
Default: TRUE.}
}
\value{
Either:
\itemize{
\item Updated mcmodule with new filtered node (when mcmodule and \code{name} provided).
\item Filtered mcnode object (when only \code{data} and \code{mcnode} provided).
}

Either:
\itemize{
\item An updated mcmodule with a new filtered node (when mcmodule and name are provided)
\item A raw filtered mcnode object (when only data and mcnode are provided)
}
}
\description{
Filters variates (data rows) from an mcnode based on logical conditions,
similar to \code{dplyr::filter()}. Can return a new node in the mcmodule or
return a filtered mcnode directly.
}
\details{
Call signatures:
\itemize{
\item To add filtered node to mcmodule: \code{mc_filter(mcmodule, "node", conditions, name = "new_name")}
\item To return filtered mcnode only: \code{mc_filter(conditions, data = data, mcnode = mcnode)}
}

Filter conditions work on variates (data rows); only rows meeting all conditions
are retained in the resulting mcnode.
}
\examples{
# Filter within an mcmodule and create new node
imports_mcmodule <- mc_filter(
  imports_mcmodule,
  "w_prev",
  origin == "nord",
  name = "w_prev_countryA"
)

# Filter and return raw mcnode (note: conditions before named args)
w_prev <- imports_mcmodule$node_list$w_prev$mcnode
w_prev_filtered <- mc_filter(
  origin == "nord",
  data = imports_data,
  mcnode = w_prev
)

# Multiple filter conditions
imports_mcmodule <- mc_filter(
  imports_mcmodule,
  "w_prev",
  origin == "nord",
  pathogen == "virus",
  name = "w_prev_countryA_virus"
)
}
