% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_analysis.R
\name{mcmodule_to_mc}
\alias{mcmodule_to_mc}
\title{Convert Monte Carlo Module to \code{mc2d} Objects}
\usage{
mcmodule_to_mc(
  mcmodule,
  mc_names = NULL,
  match = FALSE,
  variates_as_nsv = FALSE
)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module to convert.}

\item{mc_names}{(character vector, optional). Node names to include. If NULL,
includes all nodes. Default: NULL.}

\item{match}{(logical, unused). Reserved for future functionality. Default: FALSE.}

\item{variates_as_nsv}{(logical). If TRUE, combine all variates into a single
mc object by multiplying variates by uncertainty simulations in the
variability dimension. If FALSE, return one mc object per variate.
Default: FALSE.}
}
\value{
If \code{variates_as_nsv = FALSE}, a list of mc objects (one per variate).
If \code{variates_as_nsv = TRUE}, a single mc object with all variates combined
into the variability dimension. Each mc object is compatible with mc2d
package functions.
}
\description{
Converts an mcmodule into one or more mc objects (from the mc2d package).
Returns either one mc object per variate or a single mc object with all
variates combined into the variability dimension.
}
