% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_mctable.R
\name{set_mctable}
\alias{set_mctable}
\title{Set or Get Monte Carlo Inputs Table}
\usage{
set_mctable(data = NULL)
}
\arguments{
\item{data}{(data frame, optional). mctable with at minimum an \code{mcnode} column.
Other columns auto-filled if absent. If NULL, returns the current table.
Default: NULL.}
}
\value{
Current or newly set mctable. Columns include: mcnode (required),
description, mc_func, from_variable, transformation, sensi_baseline,
sensi_variation.
}
\description{
Manages the global mctable (Monte Carlo nodes reference table) by setting
or retrieving its value. The table stores metadata about mcnodes including
descriptions, functions, and sensitivity analysis parameters.
}
\examples{
# Get current MC table
current_table <- set_mctable()

# Set new MC table
mct <- data.frame(
  mcnode = c("h_prev", "w_prev"),
  description = c("Herd prevalence", "Within herd prevalence"),
  mc_func = c("runif", "runif")
)
set_mctable(mct)

}
