% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_mcnode.R
\name{which_mcnode}
\alias{which_mcnode}
\title{Find mcnodes Matching a Condition}
\usage{
which_mcnode(mcmodule, test_func)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing node_list with mcnodes.}

\item{test_func}{(function). Function that takes an mcnode and returns logical;
TRUE if the condition is met.}
}
\value{
Character vector of mcnode names where \code{test_func} returns TRUE.
Empty vector if no nodes meet the condition.
}
\description{
Applies a test function to each mcnode in an mcmodule and returns the
names of nodes where the test returns TRUE. Useful for identifying nodes
with specific properties (e.g., NA values, negative values).
}
\examples{
# Find nodes with negative values
which_mcnode(imports_mcmodule, function(x) any(x < 0, na.rm = TRUE))

# Find nodes with values greater than 1
which_mcnode(imports_mcmodule, function(x) any(x > 1, na.rm = TRUE))

}
\seealso{
\code{\link[=which_mcnode_na]{which_mcnode_na()}}, \code{\link[=which_mcnode_inf]{which_mcnode_inf()}}
}
