% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_mcnode.R
\name{which_mcnode_inf}
\alias{which_mcnode_inf}
\title{Find mcnodes with Infinite Values}
\usage{
which_mcnode_inf(mcmodule)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing node_list.}
}
\value{
Character vector of mcnode names containing infinite values. Returns
empty vector if no infinite values found.
}
\description{
Identifies which mcnodes within an mcmodule contain infinite values
(Inf or -Inf). Useful for troubleshooting and debugging Monte Carlo models.
}
\examples{
# Find nodes with infinite values in the imports_mcmodule
which_mcnode_inf(imports_mcmodule)

# Create a test mcmodule with Inf values
test_mcnode_inf <- mcdata(c(0.1, Inf, 0.3), type = "0", nvariates = 3)
test_mcnode_clean <- mcdata(c(0.1, 0.2, 0.3), type = "0", nvariates = 3)
test_mcmodule <- list(
  node_list = list(
    node_a = list(mcnode = test_mcnode_inf),
    node_b = list(mcnode = test_mcnode_clean)
  )
)
which_mcnode_inf(test_mcmodule)

}
\seealso{
\code{\link[=which_mcnode]{which_mcnode()}}, \code{\link[=which_mcnode_na]{which_mcnode_na()}}, \code{\link[=mcnode_na_rm]{mcnode_na_rm()}}
}
