% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Violations}
\alias{Violations}
\alias{ViolationCodes}
\alias{Cuisines}
\title{NYC Restaurant Health Violations}
\format{
A data frame with 480,621 observations on the following 16 variables.
\describe{
\item{camis}{unique identifier}
\item{dba}{full name doing business as}
\item{boro}{borough of New York}
\item{building}{building name}
\item{street}{street address}
\item{zipcode}{zipcode}
\item{phone}{phone number}
\item{inspection_date}{inspection date}
\item{action}{action taken}
\item{violation_code}{violation code, see \link{ViolationCodes}}
\item{score}{inspection score}
\item{grade}{inspection grade}
\item{grade_date}{grade date}
\item{record_date}{recording date}
\item{inspection_type}{inspect type}
\item{cuisine_code}{cuisine code, see \link{Cuisines}}
}

A data frame with 174 observations on the following 3 variables.
\describe{
\item{violation_code}{a factor with many levels}
\item{critical_flag}{is violation critical: a factor with levels \code{N}, \code{Y}}
\item{violation_description}{violation description}
}

A data frame with 84 observations on the following 2 variables.
\describe{
\item{cuisine_code}{a character vector}
\item{cuisine_description}{a character vector}
}
}
\source{
\href{https://data.cityofnewyork.us/Health/DOHMH-New-York-City-Restaurant-Inspection-Results/43nn-pn8j/}{NYC Open Data}
}
\usage{
Violations

ViolationCodes

Cuisines
}
\description{
NYC Restaurant Health Violations
}
\examples{
data(Violations)
if (require(dplyr)) {
  Violations |>
    inner_join(Cuisines, by = "cuisine_code") |>
    filter(cuisine_description == "American") |>
    arrange(grade_date) |>
    head()
 }
}
\seealso{
\link{ViolationCodes}, \link{Cuisines}
}
\keyword{datasets}
