% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape_summary.R
\name{landscape_summary}
\alias{landscape_summary}
\title{Forest and soil summaries over space}
\usage{
landscape_summary(
  object,
  name,
  summary_function,
  ...,
  unlist = FALSE,
  progress = FALSE
)
}
\arguments{
\item{object}{An object of class \code{\link[sf]{sf}}.}

\item{name}{A string of the element to summarize: "forest", "soil" or "state".}

\item{summary_function}{A function that accepts objects of class \code{\link[medfate]{forest}}, \code{\link[medfate]{soil}} or model input objects, respectively.}

\item{...}{Additional arguments to the summary function.}

\item{unlist}{Logical flag to try converting the summaries into different columns}

\item{progress}{Boolean flag to display progress information}
}
\value{
An object of class \code{\link[sf]{sf}} containing the calculated statistics.
If \code{unlist = FALSE} column 'summary' is a list with summaries for each element.
If \code{unlist = TRUE} different columns are returned instead, one per variable given in the summary function.
}
\description{
Functions to calculates a summary function for the forest or soil of all spatial elements
in an object of class \code{\link[sf]{sf}} containing landscape information.
}
\examples{
# Load plot data and species parameters from medfate
data(example_ifn)

# Load default medfate parameters
data("SpParamsMED")
 
# Apply forest summary function
landscape_summary(example_ifn, "forest", summary.forest, SpParamsMED)
 
}
\seealso{
\code{\link[medfate]{forest}}, \code{\link[medfate]{soil}}, \code{\link[medfate]{summary.forest}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF.
}
