% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stata_parser.R
\name{parse_stata_labels}
\alias{parse_stata_labels}
\title{Parse STATA label commands from source lines}
\usage{
parse_stata_labels(lines)
}
\arguments{
\item{lines}{Character vector of source lines
(already comment-stripped)}
}
\value{
A list with var_labels (named list) and val_labels
(named list of named lists)
}
\description{
Extracts variable labels, value label definitions, and
value label assignments from label commands.
}
\examples{
\donttest{
lines <- c(
  'label variable edad "Age in years"',
  'label define sexo_lbl 1 "Male" 2 "Female"',
  "label values sexo sexo_lbl"
)
labels <- parse_stata_labels(lines)
labels$var_labels
labels$val_labels
}
}
\seealso{
Other transpiler: 
\code{\link{parse_do_file}()},
\code{\link{transpile_coverage}()},
\code{\link{transpile_stata}()},
\code{\link{transpile_stata_module}()}
}
\concept{transpiler}
