% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_tidy_api.R
\name{search_workflows}
\alias{search_workflows}
\title{Search workflows}
\usage{
search_workflows(query)
}
\arguments{
\item{query}{Character search string.}
}
\value{
List of matching RecipeWorkflow objects.
}
\description{
Search for workflows by name or description in the active workflow backend.
}
\examples{
set_workflow_backend("local", path = tempfile(fileext = ".json"))
results <- search_workflows("labor market")
length(results)

}
\seealso{
\code{\link{filter_workflows}}, \code{\link{rank_workflows}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
